/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.workflow;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import org.opensearch.action.support.PlainActionFuture;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.FutureUtils;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.flowframework.exception.WorkflowStepException;
import org.opensearch.flowframework.util.ParseUtils;
import org.opensearch.flowframework.workflow.WorkflowData;
import org.opensearch.flowframework.workflow.WorkflowStep;

public class NoOpStep
implements WorkflowStep {
    public static final String NAME = "noop";

    @Override
    public PlainActionFuture<WorkflowData> execute(String currentNodeId, WorkflowData currentNodeInputs, Map<String, WorkflowData> outputs, Map<String, String> previousNodeInputs, Map<String, String> params) {
        PlainActionFuture future = PlainActionFuture.newFuture();
        Set<String> requiredKeys = Collections.emptySet();
        Set<String> optionalKeys = Set.of("delay");
        try {
            Map<String, Object> inputs = ParseUtils.getInputsFromPreviousSteps(requiredKeys, optionalKeys, currentNodeInputs, outputs, previousNodeInputs, params);
            if (inputs.containsKey("delay")) {
                long delay = TimeValue.parseTimeValue((String)inputs.get("delay").toString(), (String)"delay").millis();
                Thread.sleep(delay);
            }
        }
        catch (IllegalArgumentException iae) {
            throw new WorkflowStepException(iae.getMessage(), RestStatus.BAD_REQUEST);
        }
        catch (InterruptedException e) {
            FutureUtils.cancel((Future)future);
        }
        future.onResponse((Object)WorkflowData.EMPTY);
        return future;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

