/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.workflow;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.ingest.PutPipelineRequest;
import org.opensearch.action.search.PutSearchPipelineRequest;
import org.opensearch.action.support.PlainActionFuture;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.client.Client;
import org.opensearch.client.ClusterAdminClient;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesArray;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.flowframework.common.WorkflowResources;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.exception.WorkflowStepException;
import org.opensearch.flowframework.indices.FlowFrameworkIndicesHandler;
import org.opensearch.flowframework.util.ParseUtils;
import org.opensearch.flowframework.workflow.WorkflowData;
import org.opensearch.flowframework.workflow.WorkflowStep;

public abstract class AbstractCreatePipelineStep
implements WorkflowStep {
    private static final Logger logger = LogManager.getLogger(AbstractCreatePipelineStep.class);
    private final ClusterAdminClient clusterAdminClient;
    private final FlowFrameworkIndicesHandler flowFrameworkIndicesHandler;

    protected AbstractCreatePipelineStep(Client client, FlowFrameworkIndicesHandler flowFrameworkIndicesHandler) {
        this.clusterAdminClient = client.admin().cluster();
        this.flowFrameworkIndicesHandler = flowFrameworkIndicesHandler;
    }

    @Override
    public PlainActionFuture<WorkflowData> execute(final String currentNodeId, final WorkflowData currentNodeInputs, Map<String, WorkflowData> outputs, Map<String, String> previousNodeInputs, Map<String, String> params) {
        final PlainActionFuture createPipelineFuture = PlainActionFuture.newFuture();
        Set<String> requiredKeys = Set.of("pipeline_id", "configurations");
        Set<String> optionalKeys = Set.of("model_id");
        try {
            Map<String, Object> inputs = ParseUtils.getInputsFromPreviousSteps(requiredKeys, optionalKeys, currentNodeInputs, outputs, previousNodeInputs, params);
            final String pipelineId = (String)inputs.get("pipeline_id");
            String configurations = (String)inputs.get("configurations");
            String transformedJsonStringForStringArray = ParseUtils.removingBackslashesAndQuotesInArrayInJsonString(configurations);
            byte[] byteArr = transformedJsonStringForStringArray.getBytes(StandardCharsets.UTF_8);
            BytesArray configurationsBytes = new BytesArray(byteArr);
            final String pipelineToBeCreated = this.getName();
            ActionListener<AcknowledgedResponse> putPipelineActionListener = new ActionListener<AcknowledgedResponse>(){

                public void onResponse(AcknowledgedResponse acknowledgedResponse) {
                    String resourceName = WorkflowResources.getResourceByWorkflowStep(AbstractCreatePipelineStep.this.getName());
                    try {
                        AbstractCreatePipelineStep.this.flowFrameworkIndicesHandler.updateResourceInStateIndex(currentNodeInputs.getWorkflowId(), currentNodeId, AbstractCreatePipelineStep.this.getName(), pipelineId, (ActionListener<UpdateResponse>)ActionListener.wrap(updateResponse -> {
                            logger.info("successfully updated resources created in state index: {}", (Object)updateResponse.getIndex());
                            createPipelineFuture.onResponse((Object)new WorkflowData(Map.of(resourceName, pipelineId), currentNodeInputs.getWorkflowId(), currentNodeInputs.getNodeId()));
                        }, exception -> {
                            String errorMessage = "Failed to update new created " + currentNodeId + " resource " + AbstractCreatePipelineStep.this.getName() + " id " + pipelineId;
                            logger.error(errorMessage, (Throwable)exception);
                            createPipelineFuture.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, ExceptionsHelper.status((Throwable)exception))));
                        }));
                    }
                    catch (Exception e) {
                        String errorMessage = "Failed to parse and update new created resource";
                        logger.error(errorMessage, (Throwable)e);
                        createPipelineFuture.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, ExceptionsHelper.status((Throwable)e))));
                    }
                }

                public void onFailure(Exception ex) {
                    Exception e = WorkflowStepException.getSafeException(ex);
                    Object errorMessage = e == null ? "Failed step " + pipelineToBeCreated : e.getMessage();
                    logger.error((String)errorMessage, (Throwable)e);
                    createPipelineFuture.onFailure((Exception)((Object)new WorkflowStepException((String)errorMessage, ExceptionsHelper.status((Throwable)e))));
                }
            };
            if (pipelineToBeCreated.equals("create_search_pipeline")) {
                PutSearchPipelineRequest putSearchPipelineRequest = new PutSearchPipelineRequest(pipelineId, (BytesReference)configurationsBytes, (MediaType)XContentType.JSON);
                this.clusterAdminClient.putSearchPipeline(putSearchPipelineRequest, (ActionListener)putPipelineActionListener);
            } else {
                PutPipelineRequest putPipelineRequest = new PutPipelineRequest(pipelineId, (BytesReference)configurationsBytes, (MediaType)XContentType.JSON);
                this.clusterAdminClient.putPipeline(putPipelineRequest, (ActionListener)putPipelineActionListener);
            }
        }
        catch (FlowFrameworkException e) {
            createPipelineFuture.onFailure((Exception)((Object)e));
        }
        return createPipelineFuture;
    }
}

