/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.transport;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.PlainActionFuture;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.client.Client;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.flowframework.common.FlowFrameworkSettings;
import org.opensearch.flowframework.common.WorkflowResources;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.indices.FlowFrameworkIndicesHandler;
import org.opensearch.flowframework.model.ProvisioningProgress;
import org.opensearch.flowframework.model.ResourceCreated;
import org.opensearch.flowframework.model.State;
import org.opensearch.flowframework.transport.GetWorkflowStateAction;
import org.opensearch.flowframework.transport.GetWorkflowStateRequest;
import org.opensearch.flowframework.transport.WorkflowRequest;
import org.opensearch.flowframework.transport.WorkflowResponse;
import org.opensearch.flowframework.util.ParseUtils;
import org.opensearch.flowframework.workflow.ProcessNode;
import org.opensearch.flowframework.workflow.WorkflowData;
import org.opensearch.flowframework.workflow.WorkflowStep;
import org.opensearch.flowframework.workflow.WorkflowStepFactory;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class DeprovisionWorkflowTransportAction
extends HandledTransportAction<WorkflowRequest, WorkflowResponse> {
    private final Logger logger = LogManager.getLogger(DeprovisionWorkflowTransportAction.class);
    private final ThreadPool threadPool;
    private final Client client;
    private final WorkflowStepFactory workflowStepFactory;
    private final FlowFrameworkIndicesHandler flowFrameworkIndicesHandler;
    private final FlowFrameworkSettings flowFrameworkSettings;

    @Inject
    public DeprovisionWorkflowTransportAction(TransportService transportService, ActionFilters actionFilters, ThreadPool threadPool, Client client, WorkflowStepFactory workflowStepFactory, FlowFrameworkIndicesHandler flowFrameworkIndicesHandler, FlowFrameworkSettings flowFrameworkSettings) {
        super("cluster:admin/opensearch/flow_framework/workflow/deprovision", transportService, actionFilters, WorkflowRequest::new);
        this.threadPool = threadPool;
        this.client = client;
        this.workflowStepFactory = workflowStepFactory;
        this.flowFrameworkIndicesHandler = flowFrameworkIndicesHandler;
        this.flowFrameworkSettings = flowFrameworkSettings;
    }

    protected void doExecute(Task task, WorkflowRequest request, ActionListener<WorkflowResponse> listener) {
        String workflowId = request.getWorkflowId();
        String allowDelete = request.getParams().get("allow_delete");
        GetWorkflowStateRequest getStateRequest = new GetWorkflowStateRequest(workflowId, true);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.logger.info("Querying state for workflow: {}", (Object)workflowId);
            this.client.execute((ActionType)GetWorkflowStateAction.INSTANCE, (ActionRequest)getStateRequest, ActionListener.wrap(response -> {
                context.restore();
                Set deleteAllowedResources = Strings.tokenizeByCommaToSet((String)allowDelete);
                this.threadPool.executor("opensearch_deprovision_workflow").execute(() -> this.executeDeprovisionSequence(workflowId, response.getWorkflowState().resourcesCreated(), deleteAllowedResources, listener));
            }, exception -> {
                String errorMessage = "Failed to get workflow state for workflow " + workflowId;
                this.logger.error(errorMessage, (Throwable)exception);
                listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, ExceptionsHelper.status((Throwable)exception))));
            }));
        }
        catch (Exception e) {
            String errorMessage = "Failed to retrieve template from global context.";
            this.logger.error(errorMessage, (Throwable)e);
            listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, ExceptionsHelper.status((Throwable)e))));
        }
    }

    private void executeDeprovisionSequence(String workflowId, List<ResourceCreated> resourcesCreated, Set<String> deleteAllowedResources, ActionListener<WorkflowResponse> listener) {
        ArrayList<ResourceCreated> deleteNotAllowed = new ArrayList<ResourceCreated>();
        List<ProcessNode> deprovisionProcessSequence = new ArrayList<ProcessNode>();
        for (ResourceCreated resource : resourcesCreated) {
            String workflowStepId = resource.workflowStepId();
            String stepName = resource.workflowStepName();
            WorkflowStep deprovisionStep = this.workflowStepFactory.createStep(WorkflowResources.getDeprovisionStepByWorkflowStep(stepName));
            if (deprovisionStep.allowDeleteRequired() && !deleteAllowedResources.contains(resource.resourceId())) {
                deleteNotAllowed.add(resource);
                continue;
            }
            String deprovisionStepId = "(deprovision_" + stepName + ") " + workflowStepId;
            deprovisionProcessSequence.add(new ProcessNode(deprovisionStepId, deprovisionStep, Collections.emptyMap(), Collections.emptyMap(), new WorkflowData(Map.of(WorkflowResources.getResourceByWorkflowStep(stepName), resource.resourceId()), workflowId, deprovisionStepId), Collections.emptyList(), this.threadPool, "opensearch_deprovision_workflow", this.flowFrameworkSettings.getRequestTimeout()));
        }
        Collections.reverse(deprovisionProcessSequence);
        this.logger.info("Deprovisioning steps: {}", (Object)deprovisionProcessSequence.stream().map(ProcessNode::id).collect(Collectors.joining(", ")));
        int resourceCount = deprovisionProcessSequence.size();
        while (resourceCount > 0) {
            Iterator iter = deprovisionProcessSequence.iterator();
            while (iter.hasNext()) {
                ProcessNode deprovisionNode = (ProcessNode)iter.next();
                ResourceCreated resource = DeprovisionWorkflowTransportAction.getResourceFromDeprovisionNode(deprovisionNode, resourcesCreated);
                String resourceNameAndId = DeprovisionWorkflowTransportAction.getResourceNameAndId(resource);
                PlainActionFuture<WorkflowData> deprovisionFuture = deprovisionNode.execute();
                try {
                    deprovisionFuture.get();
                    this.logger.info("Successful {} for {}", (Object)deprovisionNode.id(), (Object)resourceNameAndId);
                    iter.remove();
                    Thread.sleep(100L);
                }
                catch (Throwable t) {
                    if (t.getCause() instanceof OpenSearchStatusException && ((OpenSearchStatusException)t.getCause()).status() == RestStatus.NOT_FOUND) {
                        this.logger.info("Successful (not found) {} for {}", (Object)deprovisionNode.id(), (Object)resourceNameAndId);
                        iter.remove();
                        continue;
                    }
                    this.logger.info("Failed {} for {}", (Object)deprovisionNode.id(), (Object)resourceNameAndId);
                }
            }
            if (deprovisionProcessSequence.size() >= resourceCount) break;
            resourceCount = deprovisionProcessSequence.size();
            deprovisionProcessSequence = deprovisionProcessSequence.stream().map(pn -> new ProcessNode(pn.id(), this.workflowStepFactory.createStep(pn.workflowStep().getName()), pn.previousNodeInputs(), pn.params(), pn.input(), pn.predecessors(), this.threadPool, "opensearch_deprovision_workflow", pn.nodeTimeout())).collect(Collectors.toList());
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
        List<ResourceCreated> remainingResources = deprovisionProcessSequence.stream().map(pn -> DeprovisionWorkflowTransportAction.getResourceFromDeprovisionNode(pn, resourcesCreated)).collect(Collectors.toList());
        this.logger.info("Resources remaining: {}.", remainingResources);
        if (!deleteNotAllowed.isEmpty()) {
            this.logger.info("Resources requiring allow_delete: {}.", deleteNotAllowed);
        }
        this.updateWorkflowState(workflowId, remainingResources, deleteNotAllowed, listener);
    }

    private void updateWorkflowState(String workflowId, List<ResourceCreated> remainingResources, List<ResourceCreated> deleteNotAllowed, ActionListener<WorkflowResponse> listener) {
        if (remainingResources.isEmpty() && deleteNotAllowed.isEmpty()) {
            this.flowFrameworkIndicesHandler.doesTemplateExist(workflowId, templateExists -> {
                if (Boolean.TRUE.equals(templateExists)) {
                    this.flowFrameworkIndicesHandler.putInitialStateToWorkflowState(workflowId, ParseUtils.getUserContext(this.client), (ActionListener<IndexResponse>)ActionListener.wrap(indexResponse -> this.logger.info("Reset workflow {} state to NOT_STARTED", (Object)workflowId), exception -> this.logger.error("Failed to reset to initial workflow state for {}", (Object)workflowId, exception)));
                } else {
                    this.flowFrameworkIndicesHandler.deleteFlowFrameworkSystemIndexDoc(workflowId, (ActionListener<DeleteResponse>)ActionListener.wrap(deleteResponse -> this.logger.info("Deleted workflow {} state", (Object)workflowId), exception -> this.logger.error("Failed to delete workflow state for {}", (Object)workflowId, exception)));
                }
                listener.onResponse((Object)new WorkflowResponse(workflowId));
            }, listener);
        } else {
            ArrayList<ResourceCreated> stateIndexResources = new ArrayList<ResourceCreated>(remainingResources);
            stateIndexResources.addAll(deleteNotAllowed);
            this.flowFrameworkIndicesHandler.updateFlowFrameworkSystemIndexDoc(workflowId, Map.ofEntries(Map.entry("state", State.COMPLETED), Map.entry("provisioning_progress", ProvisioningProgress.DONE), Map.entry("provision_end_time", Instant.now().toEpochMilli()), Map.entry("resources_created", stateIndexResources)), (ActionListener<UpdateResponse>)ActionListener.wrap(updateResponse -> this.logger.info("updated workflow {} state to COMPLETED", (Object)workflowId), exception -> this.logger.error("Failed to update workflow {} state", (Object)workflowId, exception)));
            StringBuilder message = new StringBuilder();
            DeprovisionWorkflowTransportAction.appendResourceInfo(message, "Failed to deprovision some resources: ", remainingResources);
            DeprovisionWorkflowTransportAction.appendResourceInfo(message, "These resources require the allow_delete parameter to deprovision: ", deleteNotAllowed);
            listener.onFailure((Exception)((Object)new FlowFrameworkException(message.toString(), remainingResources.isEmpty() ? RestStatus.FORBIDDEN : RestStatus.ACCEPTED)));
        }
    }

    private static void appendResourceInfo(StringBuilder message, String prefix, List<ResourceCreated> resources) {
        if (!resources.isEmpty()) {
            if (message.length() > 0) {
                message.append(" ");
            }
            message.append(prefix).append(resources.stream().map(DeprovisionWorkflowTransportAction::getResourceNameAndId).filter(Objects::nonNull).distinct().collect(Collectors.joining(", ", "[", "]"))).append(".");
        }
    }

    private static ResourceCreated getResourceFromDeprovisionNode(ProcessNode deprovisionNode, List<ResourceCreated> resourcesCreated) {
        return resourcesCreated.stream().filter(r -> deprovisionNode.id().equals("(deprovision_" + r.workflowStepName() + ") " + r.workflowStepId())).findFirst().orElse(null);
    }

    private static String getResourceNameAndId(ResourceCreated resource) {
        if (resource == null) {
            return null;
        }
        return WorkflowResources.getResourceByWorkflowStep(resource.workflowStepName()) + " " + resource.resourceId();
    }
}

