/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.PasswordBasedDeriver;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.Mac;
import org.bouncycastle.crypto.internal.PBEParametersGenerator;
import org.bouncycastle.crypto.internal.params.KeyParameterImpl;
import org.bouncycastle.crypto.internal.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PKCS5S2ParametersGenerator<T extends Parameters>
extends PBEParametersGenerator<T> {
    private Mac hMac;
    private byte[] state;

    public PKCS5S2ParametersGenerator(T t, Mac mac) {
        super(t);
        this.hMac = mac;
        this.state = new byte[mac.getMacSize()];
    }

    private void F(byte[] byArray, int n, byte[] byArray2, byte[] byArray3, int n2) {
        if (n == 0) {
            throw new IllegalArgumentException("iteration count must be at least 1.");
        }
        if (byArray != null) {
            this.hMac.update(byArray, 0, byArray.length);
        }
        this.hMac.update(byArray2, 0, byArray2.length);
        this.hMac.doFinal(this.state, 0);
        System.arraycopy(this.state, 0, byArray3, n2, this.state.length);
        for (int i = 1; i < n; ++i) {
            this.hMac.update(this.state, 0, this.state.length);
            this.hMac.doFinal(this.state, 0);
            for (int j = 0; j != this.state.length; ++j) {
                int n3 = n2 + j;
                byArray3[n3] = (byte)(byArray3[n3] ^ this.state[j]);
            }
        }
    }

    private byte[] generateDerivedKey(int n) {
        int n2 = this.hMac.getMacSize();
        int n3 = (n + n2 - 1) / n2;
        byte[] byArray = new byte[4];
        byte[] byArray2 = new byte[n3 * n2];
        int n4 = 0;
        KeyParameterImpl keyParameterImpl = new KeyParameterImpl(this.password);
        this.hMac.init(keyParameterImpl);
        for (int i = 1; i <= n3; ++i) {
            int n5;
            int n6 = 3;
            do {
                n5 = n6--;
            } while ((byArray[n5] = (byte)(byArray[n5] + 1)) == 0);
            this.F(this.salt, this.iterationCount, byArray, byArray2, n4);
            n4 += n2;
        }
        return byArray2;
    }

    @Override
    public CipherParameters generateDerivedParameters(int n) {
        byte[] byArray = this.deriveKey(PasswordBasedDeriver.KeyType.CIPHER, n /= 8);
        return new KeyParameterImpl(byArray);
    }

    @Override
    public CipherParameters generateDerivedParameters(int n, int n2) {
        byte[][] byArray = this.deriveKeyAndIV(PasswordBasedDeriver.KeyType.CIPHER, n /= 8, n2 /= 8);
        return new ParametersWithIV(new KeyParameterImpl(byArray[0]), byArray[1], n, n2);
    }

    @Override
    public CipherParameters generateDerivedMacParameters(int n) {
        return this.generateDerivedParameters(n);
    }

    @Override
    public byte[] deriveKey(PasswordBasedDeriver.KeyType keyType, int n) {
        switch (keyType) {
            case CIPHER: 
            case MAC: {
                return Arrays.copyOfRange(this.generateDerivedKey(n), 0, n);
            }
        }
        throw new IllegalStateException("Unknown type in deriveKey: " + keyType.name());
    }

    @Override
    public byte[][] deriveKeyAndIV(PasswordBasedDeriver.KeyType keyType, int n, int n2) {
        byte[][] byArrayArray = new byte[2][];
        byte[] byArray = this.generateDerivedKey(n + n2);
        switch (keyType) {
            case CIPHER: 
            case MAC: {
                byArrayArray[0] = Arrays.copyOfRange(byArray, 0, n);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown type in deriveKeyAndIV: " + keyType.name());
            }
        }
        byArrayArray[1] = Arrays.copyOfRange(byArray, n, n + n2);
        return byArrayArray;
    }
}

