/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.codec.customcodecs;

import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.FilterCodec;
import org.apache.lucene.codecs.StoredFieldsFormat;
import org.apache.lucene.codecs.lucene99.Lucene99Codec;
import org.opensearch.common.settings.Settings;
import org.opensearch.index.codec.PerFieldMappingPostingFormatCodec;
import org.opensearch.index.codec.customcodecs.Lucene99CustomStoredFieldsFormat;
import org.opensearch.index.engine.EngineConfig;
import org.opensearch.index.mapper.MapperService;

public abstract class Lucene99CustomCodec
extends FilterCodec {
    public static final int DEFAULT_COMPRESSION_LEVEL = (Integer)EngineConfig.INDEX_CODEC_COMPRESSION_LEVEL_SETTING.getDefault(Settings.EMPTY);
    private final StoredFieldsFormat storedFieldsFormat;

    public Lucene99CustomCodec(Mode mode) {
        this(mode, DEFAULT_COMPRESSION_LEVEL);
    }

    public Lucene99CustomCodec(Mode mode, int compressionLevel) {
        super(mode.getCodec(), (Codec)new Lucene99Codec());
        this.storedFieldsFormat = new Lucene99CustomStoredFieldsFormat(mode, compressionLevel);
    }

    public Lucene99CustomCodec(Mode mode, int compressionLevel, MapperService mapperService, Logger logger) {
        super(mode.getCodec(), (Codec)new PerFieldMappingPostingFormatCodec(Lucene99Codec.Mode.BEST_SPEED, mapperService, logger));
        this.storedFieldsFormat = new Lucene99CustomStoredFieldsFormat(mode, compressionLevel);
    }

    public StoredFieldsFormat storedFieldsFormat() {
        return this.storedFieldsFormat;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public static enum Mode {
        ZSTD("ZSTD99", Set.of("zstd")),
        ZSTD_NO_DICT("ZSTDNODICT99", Set.of("zstd_no_dict"));

        private final String codec;
        private final Set<String> aliases;

        private Mode(String codec, Set<String> aliases) {
            this.codec = codec;
            this.aliases = aliases;
        }

        public String getCodec() {
            return this.codec;
        }

        public Set<String> getAliases() {
            return this.aliases;
        }
    }
}

