/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.provenance.primitives;

import com.oracle.labs.mlrg.olcut.provenance.PrimitiveProvenance;
import java.util.Objects;

public final class FloatProvenance
implements PrimitiveProvenance<Float> {
    private static final long serialVersionUID = 1L;
    private final String key;
    private final float value;

    public FloatProvenance(String key, float value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public Float getValue() {
        return Float.valueOf(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FloatProvenance)) {
            return false;
        }
        FloatProvenance that = (FloatProvenance)o;
        return this.key.equals(that.key) && Float.compare(this.value, that.value) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.key, Float.valueOf(this.value));
    }

    public String toString() {
        return "" + this.value;
    }
}

