/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.remote;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.blobstore.BlobPath;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.remote.RemoteStoreEnums;
import org.opensearch.index.remote.RemoteStorePathStrategy;

@ExperimentalApi
public class RemoteIndexPath
implements ToXContentFragment {
    public static final Map<RemoteStoreEnums.DataCategory, List<RemoteStoreEnums.DataType>> TRANSLOG_PATH = Map.of(RemoteStoreEnums.DataCategory.TRANSLOG, List.of(RemoteStoreEnums.DataType.DATA, RemoteStoreEnums.DataType.METADATA));
    public static final Map<RemoteStoreEnums.DataCategory, List<RemoteStoreEnums.DataType>> SEGMENT_PATH = Map.of(RemoteStoreEnums.DataCategory.SEGMENTS, List.of(RemoteStoreEnums.DataType.values()));
    public static final Map<RemoteStoreEnums.DataCategory, List<RemoteStoreEnums.DataType>> COMBINED_PATH;
    public static final String DEFAULT_VERSION = "1";
    public static final String DIR = "remote-index-path";
    public static final String FILE_NAME_FORMAT = "remote_path_%s";
    static final String KEY_VERSION = "version";
    static final String KEY_INDEX_UUID = "index_uuid";
    static final String KEY_SHARD_COUNT = "shard_count";
    static final String KEY_PATH_CREATION_MAP = "path_creation_map";
    static final String KEY_PATHS = "paths";
    private final String version;
    private final String indexUUID;
    private final int shardCount;
    private final Iterable<String> basePath;
    private final RemoteStoreEnums.PathType pathType;
    private final RemoteStoreEnums.PathHashAlgorithm pathHashAlgorithm;
    private final Map<RemoteStoreEnums.DataCategory, List<RemoteStoreEnums.DataType>> pathCreationMap;

    public RemoteIndexPath(String indexUUID, int shardCount, Iterable<String> basePath, RemoteStoreEnums.PathType pathType, RemoteStoreEnums.PathHashAlgorithm pathHashAlgorithm, Map<RemoteStoreEnums.DataCategory, List<RemoteStoreEnums.DataType>> pathCreationMap) {
        if (Objects.isNull(pathCreationMap) || Objects.isNull((Object)pathType) || !RemoteStorePathStrategy.isCompatible(pathType, pathHashAlgorithm) || shardCount < 1 || Objects.isNull(basePath) || pathCreationMap.isEmpty() || pathCreationMap.keySet().stream().anyMatch(k -> ((List)pathCreationMap.get(k)).isEmpty())) {
            ParameterizedMessage parameterizedMessage = new ParameterizedMessage("Invalid input in RemoteIndexPath constructor indexUUID={} shardCount={} basePath={} pathType={} pathHashAlgorithm={} pathCreationMap={}", new Object[]{indexUUID, shardCount, basePath, pathType, pathHashAlgorithm, pathCreationMap});
            throw new IllegalArgumentException(parameterizedMessage.getFormattedMessage());
        }
        boolean validMap = pathCreationMap.keySet().stream().allMatch(k -> ((List)pathCreationMap.get(k)).stream().allMatch(k::isSupportedDataType));
        if (!validMap) {
            throw new IllegalArgumentException(new ParameterizedMessage("pathCreationMap={} is having illegal combination of category and type", pathCreationMap).getFormattedMessage());
        }
        this.version = DEFAULT_VERSION;
        this.indexUUID = indexUUID;
        this.shardCount = shardCount;
        this.basePath = basePath;
        this.pathType = pathType;
        this.pathHashAlgorithm = pathHashAlgorithm;
        this.pathCreationMap = pathCreationMap;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(KEY_VERSION, this.version);
        builder.field(KEY_INDEX_UUID, this.indexUUID);
        builder.field(KEY_SHARD_COUNT, this.shardCount);
        builder.field("path_type", this.pathType.name());
        if (Objects.nonNull((Object)this.pathHashAlgorithm)) {
            builder.field("path_hash_algorithm", this.pathHashAlgorithm.name());
        }
        HashMap pathMap = new HashMap();
        for (Map.Entry<RemoteStoreEnums.DataCategory, List<RemoteStoreEnums.DataType>> entry : this.pathCreationMap.entrySet()) {
            pathMap.put(entry.getKey().getName(), entry.getValue().stream().map(RemoteStoreEnums.DataType::getName).collect(Collectors.toList()));
        }
        builder.field(KEY_PATH_CREATION_MAP);
        builder.map(pathMap);
        builder.startArray(KEY_PATHS);
        for (Map.Entry<RemoteStoreEnums.DataCategory, List<RemoteStoreEnums.DataType>> entry : this.pathCreationMap.entrySet()) {
            RemoteStoreEnums.DataCategory dataCategory = entry.getKey();
            for (RemoteStoreEnums.DataType type : entry.getValue()) {
                for (int shardNo = 0; shardNo < this.shardCount; ++shardNo) {
                    RemoteStorePathStrategy.PathInput pathInput = RemoteStorePathStrategy.PathInput.builder().basePath(new BlobPath().add(this.basePath)).indexUUID(this.indexUUID).shardId(Integer.toString(shardNo)).dataCategory(dataCategory).dataType(type).build();
                    builder.value(this.pathType.path((RemoteStorePathStrategy.BasePathInput)pathInput, this.pathHashAlgorithm).buildAsString());
                }
            }
        }
        builder.endArray();
        return builder;
    }

    public static RemoteIndexPath fromXContent(XContentParser ignored) {
        throw new UnsupportedOperationException("RemoteIndexPath.fromXContent() is not supported");
    }

    String getVersion() {
        return this.version;
    }

    static {
        HashMap<RemoteStoreEnums.DataCategory, List<RemoteStoreEnums.DataType>> combinedPath = new HashMap<RemoteStoreEnums.DataCategory, List<RemoteStoreEnums.DataType>>();
        combinedPath.putAll(TRANSLOG_PATH);
        combinedPath.putAll(SEGMENT_PATH);
        COMBINED_PATH = Collections.unmodifiableMap(combinedPath);
    }
}

