/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.index.IndexableField;
import org.opensearch.OpenSearchParseException;
import org.opensearch.common.time.DateFormatter;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.xcontent.XContent;
import org.opensearch.index.analysis.IndexAnalyzers;
import org.opensearch.index.mapper.DateFieldMapper;
import org.opensearch.index.mapper.DerivedField;
import org.opensearch.index.mapper.DerivedFieldSupportedTypes;
import org.opensearch.index.mapper.DerivedFieldType;
import org.opensearch.index.mapper.DerivedFieldValueFetcher;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.script.DerivedFieldScript;
import org.opensearch.search.lookup.SearchLookup;
import org.opensearch.search.lookup.SourceLookup;

public class ObjectDerivedFieldType
extends DerivedFieldType {
    ObjectDerivedFieldType(DerivedField derivedField, FieldMapper typeFieldMapper, Function<Object, IndexableField> fieldFunction, IndexAnalyzers indexAnalyzers) {
        super(derivedField, typeFieldMapper, derivedField.getType().equals(DerivedFieldSupportedTypes.DATE.getName()) ? o -> {
            if (o instanceof String) {
                return (IndexableField)fieldFunction.apply(((DateFieldMapper)typeFieldMapper).fieldType().parse((String)o));
            }
            return (IndexableField)fieldFunction.apply(o);
        } : fieldFunction, indexAnalyzers);
    }

    @Override
    public DerivedFieldValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String format) {
        if (format != null) {
            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
        }
        Function<Object, Object> valueForDisplay = DerivedFieldSupportedTypes.getValueForDisplayGenerator(this.getType(), this.derivedField.getFormat() != null ? DateFormatter.forPattern(this.derivedField.getFormat()) : null);
        Function<Object, Object> valueForDisplayUpdated = this.derivedField.getType().equals(DerivedFieldSupportedTypes.DATE.getName()) ? o -> {
            if (o instanceof String) {
                return valueForDisplay.apply(((DateFieldMapper)this.typeFieldMapper).fieldType().parse((String)o));
            }
            return valueForDisplay.apply(o);
        } : valueForDisplay;
        String subFieldName = this.name().substring(this.name().indexOf(".") + 1);
        return new ObjectDerivedFieldValueFetcher(subFieldName, ObjectDerivedFieldType.getDerivedFieldLeafFactory(this.derivedField.getScript(), context, searchLookup == null ? context.lookup() : searchLookup), valueForDisplayUpdated, this.derivedField.getIgnoreMalformed());
    }

    static class ObjectDerivedFieldValueFetcher
    extends DerivedFieldValueFetcher {
        private final String subField;
        private final boolean ignoreOnMalFormed;

        ObjectDerivedFieldValueFetcher(String subField, DerivedFieldScript.LeafFactory derivedFieldScriptFactory, Function<Object, Object> valueForDisplay, boolean ignoreOnMalFormed) {
            super(derivedFieldScriptFactory, valueForDisplay);
            this.subField = subField;
            this.ignoreOnMalFormed = ignoreOnMalFormed;
        }

        @Override
        public List<Object> fetchValuesInternal(SourceLookup lookup) {
            List<Object> jsonObjects = super.fetchValuesInternal(lookup);
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object o : jsonObjects) {
                try {
                    if (o == null) continue;
                    Map<String, Object> s = XContentHelper.convertToMap((XContent)JsonXContent.jsonXContent, (String)o, false);
                    Object nestedFieldObj = ObjectDerivedFieldValueFetcher.getNestedField(s, this.subField);
                    if (nestedFieldObj instanceof List) {
                        result.addAll((List)nestedFieldObj);
                        continue;
                    }
                    result.add(nestedFieldObj);
                }
                catch (OpenSearchParseException e) {
                    if (this.ignoreOnMalFormed) continue;
                    throw e;
                }
            }
            return result;
        }

        private static Object getNestedField(Map<String, Object> obj, String key) {
            String[] keyParts = key.split("\\.");
            Map currentObj = obj;
            for (int i = 0; i < keyParts.length - 1; ++i) {
                Object value = currentObj.get(keyParts[i]);
                if (!(value instanceof Map)) {
                    return null;
                }
                currentObj = (Map)value;
            }
            return currentObj.get(keyParts[keyParts.length - 1]);
        }
    }
}

