/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.asynchronous.request;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.common.Nullable;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.tasks.TaskId;
import org.opensearch.search.asynchronous.task.SubmitAsynchronousSearchTask;

public class SubmitAsynchronousSearchRequest
extends ActionRequest {
    public static long MIN_KEEP_ALIVE = TimeValue.timeValueMinutes((long)1L).millis();
    public static long MIN_WAIT_FOR_COMPLETION_TIMEOUT = TimeValue.timeValueMillis((long)0L).millis();
    public static final int DEFAULT_PRE_FILTER_SHARD_SIZE = 1;
    public static final int DEFAULT_BATCHED_REDUCE_SIZE = 5;
    public static final TimeValue DEFAULT_KEEP_ALIVE = TimeValue.timeValueDays((long)1L);
    public static final TimeValue DEFAULT_WAIT_FOR_COMPLETION_TIMEOUT = TimeValue.timeValueSeconds((long)1L);
    public static final Boolean DEFAULT_KEEP_ON_COMPLETION = Boolean.FALSE;
    public static final Boolean DEFAULT_CCS_MINIMIZE_ROUNDTRIPS = Boolean.FALSE;
    public static final Boolean DEFAULT_REQUEST_CACHE = Boolean.TRUE;
    @Nullable
    private TimeValue waitForCompletionTimeout = DEFAULT_WAIT_FOR_COMPLETION_TIMEOUT;
    @Nullable
    private Boolean keepOnCompletion = DEFAULT_KEEP_ON_COMPLETION;
    @Nullable
    private TimeValue keepAlive = DEFAULT_KEEP_ALIVE;
    private final SearchRequest searchRequest;

    public SubmitAsynchronousSearchRequest(SearchRequest searchRequest) {
        this.searchRequest = searchRequest;
        if (searchRequest.getPreFilterShardSize() == null) {
            this.searchRequest.setPreFilterShardSize(1);
        }
        this.searchRequest.setCcsMinimizeRoundtrips(DEFAULT_CCS_MINIMIZE_ROUNDTRIPS.booleanValue());
    }

    public SearchRequest getSearchRequest() {
        return this.searchRequest;
    }

    public TimeValue getWaitForCompletionTimeout() {
        return this.waitForCompletionTimeout;
    }

    public void waitForCompletionTimeout(TimeValue waitForCompletionTimeout) {
        this.waitForCompletionTimeout = waitForCompletionTimeout;
    }

    public Boolean getKeepOnCompletion() {
        return this.keepOnCompletion;
    }

    public void keepOnCompletion(boolean keepOnCompletion) {
        this.keepOnCompletion = keepOnCompletion;
    }

    public TimeValue getKeepAlive() {
        return this.keepAlive;
    }

    public void keepAlive(TimeValue keepAlive) {
        this.keepAlive = keepAlive;
    }

    public SubmitAsynchronousSearchRequest(StreamInput in) throws IOException {
        super(in);
        this.searchRequest = new SearchRequest(in);
        this.waitForCompletionTimeout = in.readOptionalTimeValue();
        this.keepAlive = in.readTimeValue();
        this.keepOnCompletion = in.readBoolean();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.searchRequest.writeTo(out);
        out.writeOptionalTimeValue(this.waitForCompletionTimeout);
        out.writeTimeValue(this.keepAlive);
        out.writeBoolean(this.keepOnCompletion.booleanValue());
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.searchRequest.isSuggestOnly()) {
            validationException = ValidateActions.addValidationError((String)"suggest-only queries are not supported", validationException);
        }
        if (this.searchRequest.scroll() != null) {
            validationException = ValidateActions.addValidationError((String)"scrolls are not supported", (ActionRequestValidationException)validationException);
        }
        if (this.searchRequest.isCcsMinimizeRoundtrips()) {
            validationException = ValidateActions.addValidationError((String)("[ccs_minimize_roundtrips] must be false, got: " + this.searchRequest.isCcsMinimizeRoundtrips()), (ActionRequestValidationException)validationException);
        }
        if (this.keepAlive != null && this.keepAlive.getMillis() < MIN_KEEP_ALIVE) {
            validationException = ValidateActions.addValidationError((String)("[keep_alive] must be greater than 1 minute, got: " + this.keepAlive.toString()), (ActionRequestValidationException)validationException);
        }
        if (this.waitForCompletionTimeout != null && this.waitForCompletionTimeout.getMillis() < MIN_WAIT_FOR_COMPLETION_TIMEOUT) {
            validationException = ValidateActions.addValidationError((String)("[wait_for_completion_timeout] must be greater than 0 milliseconds, got: " + this.waitForCompletionTimeout.toString()), (ActionRequestValidationException)validationException);
        }
        return validationException != null ? validationException : this.searchRequest.validate();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SubmitAsynchronousSearchRequest request = (SubmitAsynchronousSearchRequest)((Object)o);
        return Objects.equals(this.searchRequest, request.searchRequest) && Objects.equals(this.keepAlive, request.getKeepAlive()) && Objects.equals(this.waitForCompletionTimeout, request.getWaitForCompletionTimeout()) && Objects.equals(this.keepOnCompletion, request.getKeepOnCompletion());
    }

    public int hashCode() {
        return Objects.hash(this.searchRequest, this.keepAlive, this.waitForCompletionTimeout, this.keepOnCompletion);
    }

    public SubmitAsynchronousSearchTask createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        SubmitAsynchronousSearchTask submitAsynchronousSearchTask = new SubmitAsynchronousSearchTask(id, type, action, null, parentTaskId, headers){

            public String getDescription() {
                StringBuilder sb = new StringBuilder();
                sb.append("indices[");
                Strings.arrayToDelimitedString((Object[])SubmitAsynchronousSearchRequest.this.searchRequest.indices(), (String)",", (StringBuilder)sb);
                sb.append("], ");
                if (SubmitAsynchronousSearchRequest.this.searchRequest.source() != null) {
                    sb.append("source[").append(SubmitAsynchronousSearchRequest.this.searchRequest.source().toString(SearchRequest.FORMAT_PARAMS)).append("]");
                } else {
                    sb.append("source[]");
                }
                return sb.toString();
            }
        };
        return submitAsynchronousSearchTask;
    }
}

