/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.settings;

import java.util.concurrent.atomic.AtomicBoolean;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.ml.settings.MLCommonsSettings;

public class MLFeatureEnabledSetting {
    private volatile Boolean isRemoteInferenceEnabled;
    private volatile Boolean isAgentFrameworkEnabled;
    private volatile Boolean isLocalModelEnabled;
    private volatile AtomicBoolean isConnectorPrivateIpEnabled;

    public MLFeatureEnabledSetting(ClusterService clusterService, Settings settings) {
        this.isRemoteInferenceEnabled = (Boolean)MLCommonsSettings.ML_COMMONS_REMOTE_INFERENCE_ENABLED.get(settings);
        this.isAgentFrameworkEnabled = (Boolean)MLCommonsSettings.ML_COMMONS_AGENT_FRAMEWORK_ENABLED.get(settings);
        this.isLocalModelEnabled = (Boolean)MLCommonsSettings.ML_COMMONS_LOCAL_MODEL_ENABLED.get(settings);
        this.isConnectorPrivateIpEnabled = new AtomicBoolean((Boolean)MLCommonsSettings.ML_COMMONS_CONNECTOR_PRIVATE_IP_ENABLED.get(settings));
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_REMOTE_INFERENCE_ENABLED, it -> {
            this.isRemoteInferenceEnabled = it;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_AGENT_FRAMEWORK_ENABLED, it -> {
            this.isAgentFrameworkEnabled = it;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_LOCAL_MODEL_ENABLED, it -> {
            this.isLocalModelEnabled = it;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_CONNECTOR_PRIVATE_IP_ENABLED, it -> this.isConnectorPrivateIpEnabled.set((boolean)it));
    }

    public boolean isRemoteInferenceEnabled() {
        return this.isRemoteInferenceEnabled;
    }

    public boolean isAgentFrameworkEnabled() {
        return this.isAgentFrameworkEnabled;
    }

    public boolean isLocalModelEnabled() {
        return this.isLocalModelEnabled;
    }

    public AtomicBoolean isConnectorPrivateIpEnabled() {
        return this.isConnectorPrivateIpEnabled;
    }
}

