/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.transfer;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.opensearch.knn.index.codec.transfer.VectorTransfer;
import org.opensearch.knn.index.codec.util.SerializationMode;
import org.opensearch.knn.jni.JNICommons;

public class VectorTransferByte
extends VectorTransfer {
    private List<byte[]> vectorList = new ArrayList<byte[]>();

    public VectorTransferByte(long vectorsStreamingMemoryLimit) {
        super(vectorsStreamingMemoryLimit);
    }

    @Override
    public void init(long totalLiveDocs) {
        this.totalLiveDocs = totalLiveDocs;
        this.vectorList.clear();
    }

    @Override
    public void transfer(BytesRef bytesRef) {
        this.dimension = bytesRef.length * 8;
        if (this.vectorsPerTransfer == Integer.MIN_VALUE) {
            this.vectorsPerTransfer = this.vectorsStreamingMemoryLimit / (long)bytesRef.length;
            if (this.vectorsPerTransfer == 0L) {
                this.vectorsPerTransfer = 1L;
            }
        }
        this.vectorList.add(ArrayUtil.copyOfSubArray((byte[])bytesRef.bytes, (int)bytesRef.offset, (int)(bytesRef.offset + bytesRef.length)));
        if ((long)this.vectorList.size() == this.vectorsPerTransfer) {
            this.transfer();
        }
    }

    @Override
    public void close() {
        this.transfer();
    }

    @Override
    public SerializationMode getSerializationMode(BytesRef bytesRef) {
        return SerializationMode.COLLECTIONS_OF_BYTES;
    }

    private void transfer() {
        int lengthOfVector = this.dimension / 8;
        this.vectorAddress = JNICommons.storeByteVectorData(this.vectorAddress, (byte[][])this.vectorList.toArray((T[])new byte[0][]), this.totalLiveDocs * (long)lengthOfVector);
        this.vectorList.clear();
    }
}

