/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.transfer;

import lombok.Generated;
import org.apache.lucene.util.BytesRef;
import org.opensearch.knn.index.codec.util.SerializationMode;

public abstract class VectorTransfer {
    protected final long vectorsStreamingMemoryLimit;
    protected long totalLiveDocs;
    protected long vectorsPerTransfer;
    protected long vectorAddress;
    protected int dimension;

    public VectorTransfer(long vectorsStreamingMemoryLimit) {
        this.vectorsStreamingMemoryLimit = vectorsStreamingMemoryLimit;
        this.vectorsPerTransfer = Integer.MIN_VALUE;
    }

    public abstract void init(long var1);

    public abstract void transfer(BytesRef var1);

    public abstract void close();

    public abstract SerializationMode getSerializationMode(BytesRef var1);

    @Generated
    public long getVectorsStreamingMemoryLimit() {
        return this.vectorsStreamingMemoryLimit;
    }

    @Generated
    public long getTotalLiveDocs() {
        return this.totalLiveDocs;
    }

    @Generated
    public long getVectorsPerTransfer() {
        return this.vectorsPerTransfer;
    }

    @Generated
    public long getVectorAddress() {
        return this.vectorAddress;
    }

    @Generated
    public int getDimension() {
        return this.dimension;
    }

    @Generated
    public void setTotalLiveDocs(long totalLiveDocs) {
        this.totalLiveDocs = totalLiveDocs;
    }

    @Generated
    public void setVectorsPerTransfer(long vectorsPerTransfer) {
        this.vectorsPerTransfer = vectorsPerTransfer;
    }

    @Generated
    public void setVectorAddress(long vectorAddress) {
        this.vectorAddress = vectorAddress;
    }

    @Generated
    public void setDimension(int dimension) {
        this.dimension = dimension;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VectorTransfer)) {
            return false;
        }
        VectorTransfer other = (VectorTransfer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getVectorsStreamingMemoryLimit() != other.getVectorsStreamingMemoryLimit()) {
            return false;
        }
        if (this.getTotalLiveDocs() != other.getTotalLiveDocs()) {
            return false;
        }
        if (this.getVectorsPerTransfer() != other.getVectorsPerTransfer()) {
            return false;
        }
        if (this.getVectorAddress() != other.getVectorAddress()) {
            return false;
        }
        return this.getDimension() == other.getDimension();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof VectorTransfer;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $vectorsStreamingMemoryLimit = this.getVectorsStreamingMemoryLimit();
        result = result * 59 + (int)($vectorsStreamingMemoryLimit >>> 32 ^ $vectorsStreamingMemoryLimit);
        long $totalLiveDocs = this.getTotalLiveDocs();
        result = result * 59 + (int)($totalLiveDocs >>> 32 ^ $totalLiveDocs);
        long $vectorsPerTransfer = this.getVectorsPerTransfer();
        result = result * 59 + (int)($vectorsPerTransfer >>> 32 ^ $vectorsPerTransfer);
        long $vectorAddress = this.getVectorAddress();
        result = result * 59 + (int)($vectorAddress >>> 32 ^ $vectorAddress);
        result = result * 59 + this.getDimension();
        return result;
    }

    @Generated
    public String toString() {
        return "VectorTransfer(vectorsStreamingMemoryLimit=" + this.getVectorsStreamingMemoryLimit() + ", totalLiveDocs=" + this.getTotalLiveDocs() + ", vectorsPerTransfer=" + this.getVectorsPerTransfer() + ", vectorAddress=" + this.getVectorAddress() + ", dimension=" + this.getDimension() + ")";
    }
}

