/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.params;

import java.util.Map;
import lombok.Generated;
import org.opensearch.knn.index.MethodComponentContext;
import org.opensearch.knn.index.codec.params.KNNVectorsFormatParams;

public class KNNScalarQuantizedVectorsFormatParams
extends KNNVectorsFormatParams {
    private Float confidenceInterval;
    private int bits;
    private boolean compressFlag;

    public KNNScalarQuantizedVectorsFormatParams(Map<String, Object> params, int defaultMaxConnections, int defaultBeamWidth) {
        super(params, defaultMaxConnections, defaultBeamWidth);
        MethodComponentContext encoderMethodComponentContext = (MethodComponentContext)params.get("encoder");
        Map<String, Object> sqEncoderParams = encoderMethodComponentContext.getParameters();
        this.initConfidenceInterval(sqEncoderParams);
        this.initBits(sqEncoderParams);
        this.initCompressFlag();
    }

    @Override
    public boolean validate(Map<String, Object> params) {
        if (params.get("encoder") == null) {
            return false;
        }
        if (!(params.get("encoder") instanceof MethodComponentContext)) {
            return false;
        }
        MethodComponentContext encoderMethodComponentContext = (MethodComponentContext)params.get("encoder");
        return "sq".equals(encoderMethodComponentContext.getName());
    }

    private void initConfidenceInterval(Map<String, Object> params) {
        if (params != null && params.containsKey("confidence_interval")) {
            if (params.get("confidence_interval").equals(0)) {
                this.confidenceInterval = Float.valueOf(0.0f);
                return;
            }
            this.confidenceInterval = Float.valueOf(((Double)params.get("confidence_interval")).floatValue());
            return;
        }
        this.confidenceInterval = null;
    }

    private void initBits(Map<String, Object> params) {
        if (params != null && params.containsKey("bits")) {
            this.bits = (Integer)params.get("bits");
            return;
        }
        this.bits = 7;
    }

    private void initCompressFlag() {
        this.compressFlag = true;
    }

    @Generated
    public Float getConfidenceInterval() {
        return this.confidenceInterval;
    }

    @Generated
    public int getBits() {
        return this.bits;
    }

    @Generated
    public boolean isCompressFlag() {
        return this.compressFlag;
    }
}

