/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.rest;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.ad.settings.ADEnabledSetting;
import org.opensearch.ad.transport.SearchAnomalyDetectorInfoAction;
import org.opensearch.client.node.NodeClient;
import org.opensearch.core.action.ActionListener;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.timeseries.transport.SearchConfigInfoRequest;

public class RestSearchAnomalyDetectorInfoAction
extends BaseRestHandler {
    public static final String SEARCH_ANOMALY_DETECTOR_INFO_ACTION = "search_anomaly_detector_info";
    private static final Logger logger = LogManager.getLogger(RestSearchAnomalyDetectorInfoAction.class);

    public String getName() {
        return SEARCH_ANOMALY_DETECTOR_INFO_ACTION;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!ADEnabledSetting.isADEnabled()) {
            throw new IllegalStateException("AD functionality is disabled. To enable update plugins.anomaly_detection.enabled to true");
        }
        String detectorName = request.param("name", null);
        String rawPath = request.rawPath();
        SearchConfigInfoRequest searchAnomalyDetectorInfoRequest = new SearchConfigInfoRequest(detectorName, rawPath);
        return channel -> client.execute((ActionType)SearchAnomalyDetectorInfoAction.INSTANCE, (ActionRequest)searchAnomalyDetectorInfoRequest, (ActionListener)new RestToXContentListener(channel));
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of();
    }

    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return ImmutableList.of((Object)new RestHandler.ReplacedRoute(RestRequest.Method.GET, String.format(Locale.ROOT, "%s/%s", "/_plugins/_anomaly_detection/detectors", "count"), RestRequest.Method.GET, String.format(Locale.ROOT, "%s/%s", "/_opendistro/_anomaly_detection/detectors", "count")), (Object)new RestHandler.ReplacedRoute(RestRequest.Method.GET, String.format(Locale.ROOT, "%s/%s", "/_plugins/_anomaly_detection/detectors", "match"), RestRequest.Method.GET, String.format(Locale.ROOT, "%s/%s", "/_opendistro/_anomaly_detection/detectors", "match")));
    }
}

