/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.indices;

import java.util.function.Supplier;
import org.opensearch.ad.indices.ADIndexManagement;
import org.opensearch.timeseries.function.ThrowingSupplierWrapper;
import org.opensearch.timeseries.indices.IndexManagement;
import org.opensearch.timeseries.indices.TimeSeriesIndex;

public enum ADIndex implements TimeSeriesIndex
{
    RESULT(".opendistro-anomaly-results", true, ThrowingSupplierWrapper.throwingSupplierWrapper(ADIndexManagement::getResultMappings)),
    CONFIG(".opendistro-anomaly-detectors", false, ThrowingSupplierWrapper.throwingSupplierWrapper(IndexManagement::getConfigMappings)),
    JOB(".opendistro-anomaly-detector-jobs", false, ThrowingSupplierWrapper.throwingSupplierWrapper(IndexManagement::getJobMappings)),
    CHECKPOINT(".opendistro-anomaly-checkpoints", false, ThrowingSupplierWrapper.throwingSupplierWrapper(ADIndexManagement::getCheckpointMappings)),
    STATE(".opendistro-anomaly-detection-state", false, ThrowingSupplierWrapper.throwingSupplierWrapper(ADIndexManagement::getStateMappings)),
    CUSTOM_RESULT("custom_result_index", true, ThrowingSupplierWrapper.throwingSupplierWrapper(ADIndexManagement::getResultMappings));

    private final String indexName;
    private final boolean alias;
    private final String mapping;

    private ADIndex(String name, boolean alias, Supplier<String> mappingSupplier) {
        this.indexName = name;
        this.alias = alias;
        this.mapping = mappingSupplier.get();
    }

    @Override
    public String getIndexName() {
        return this.indexName;
    }

    @Override
    public boolean isAlias() {
        return this.alias;
    }

    @Override
    public String getMapping() {
        return this.mapping;
    }
}

