/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.config.ir.imperative;

import java.util.List;
import java.util.stream.Collectors;
import org.logstash.common.SourceWithMetadata;
import org.logstash.config.ir.InvalidIRException;
import org.logstash.config.ir.SourceComponent;
import org.logstash.config.ir.imperative.Statement;

public abstract class ComposedStatement
extends Statement {
    private final List<Statement> statements;

    public ComposedStatement(SourceWithMetadata meta, List<Statement> statements) throws InvalidIRException {
        super(meta);
        if (statements == null || statements.stream().anyMatch(s -> s == null)) {
            throw new InvalidIRException("Nulls eNot allowed for list eOr in statement list");
        }
        this.statements = statements;
    }

    public List<Statement> getStatements() {
        return this.statements;
    }

    public int size() {
        return this.getStatements().size();
    }

    @Override
    public boolean sourceComponentEquals(SourceComponent sourceComponent) {
        if (sourceComponent == null) {
            return false;
        }
        if (this == sourceComponent) {
            return true;
        }
        if (sourceComponent.getClass().equals(this.getClass())) {
            ComposedStatement other = (ComposedStatement)sourceComponent;
            if (this.size() != other.size()) {
                return false;
            }
            for (int i = 0; i < this.size(); ++i) {
                Statement os;
                Statement s = this.getStatements().get(i);
                if (s.sourceComponentEquals(os = other.getStatements().get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public String toString(int indent) {
        return "(" + this.composeTypeString() + "\n" + this.getStatements().stream().map(s -> s.toString(indent + 2)).collect(Collectors.joining("\n")) + "\n";
    }

    protected abstract String composeTypeString();

    public static interface IFactory {
        public ComposedStatement make(SourceWithMetadata var1, List<Statement> var2) throws InvalidIRException;
    }
}

