/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs.impl;

import com.microsoft.azure.eventhubs.impl.AmqpLink;
import java.util.Locale;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseLinkHandler
extends BaseHandler {
    protected static final Logger TRACE_LOGGER = LoggerFactory.getLogger(BaseLinkHandler.class);
    private final String name;
    private final AmqpLink underlyingEntity;

    public BaseLinkHandler(AmqpLink amqpLink, String name) {
        this.name = name;
        this.underlyingEntity = amqpLink;
    }

    public void onLinkLocalClose(Event event) {
        Link link = event.getLink();
        ErrorCondition condition = link.getCondition();
        if (TRACE_LOGGER.isInfoEnabled()) {
            TRACE_LOGGER.info(String.format(Locale.US, "onLinkLocalClose clientName[%s], linkName[%s], errorCondition[%s], errorDescription[%s]", this.name, link.getName(), condition != null ? condition.getCondition() : "n/a", condition != null ? condition.getDescription() : "n/a"));
        }
        this.closeSession(link, link.getCondition());
    }

    public void onLinkRemoteClose(Event event) {
        Link link = event.getLink();
        ErrorCondition condition = link.getRemoteCondition();
        if (TRACE_LOGGER.isInfoEnabled()) {
            TRACE_LOGGER.info(String.format(Locale.US, "onLinkRemoteClose clientName[%s], linkName[%s], errorCondition[%s], errorDescription[%s]", this.name, link.getName(), condition != null ? condition.getCondition() : "n/a", condition != null ? condition.getDescription() : "n/a"));
        }
        this.handleRemoteLinkClosed(event);
    }

    public void onLinkRemoteDetach(Event event) {
        Link link = event.getLink();
        ErrorCondition condition = link.getCondition();
        if (TRACE_LOGGER.isInfoEnabled()) {
            TRACE_LOGGER.info(String.format(Locale.US, "onLinkRemoteDetach clientName[%s], linkName[%s], errorCondition[%s], errorDescription[%s]", this.name, link.getName(), condition != null ? condition.getCondition() : "n/a", condition != null ? condition.getDescription() : "n/a"));
        }
        this.handleRemoteLinkClosed(event);
    }

    public void processOnClose(Link link, ErrorCondition condition) {
        if (TRACE_LOGGER.isInfoEnabled()) {
            TRACE_LOGGER.info(String.format(Locale.US, "processOnClose clientName[%s], linkName[%s], errorCondition[%s], errorDescription[%s]", this.name, link.getName(), condition != null ? condition.getCondition() : "n/a", condition != null ? condition.getDescription() : "n/a"));
        }
        this.underlyingEntity.onClose(condition);
    }

    public void processOnClose(Link link, Exception exception) {
        if (TRACE_LOGGER.isInfoEnabled()) {
            TRACE_LOGGER.info(String.format(Locale.US, "processOnClose clientName[%s],  linkName[%s], exception[%s]", this.name, link.getName(), exception != null ? exception.getMessage() : "n/a"));
        }
        this.underlyingEntity.onError(exception);
    }

    private void closeSession(Link link, ErrorCondition condition) {
        Session session = link.getSession();
        if (session != null && session.getLocalState() != EndpointState.CLOSED) {
            if (TRACE_LOGGER.isInfoEnabled()) {
                TRACE_LOGGER.info(String.format(Locale.US, "closeSession for clientName[%s], linkName[%s], errorCondition[%s], errorDescription[%s]", this.name, link.getName(), condition != null ? condition.getCondition() : "n/a", condition != null ? condition.getDescription() : "n/a"));
            }
            session.setCondition(condition);
            session.close();
        }
    }

    private void handleRemoteLinkClosed(Event event) {
        Link link = event.getLink();
        ErrorCondition condition = link.getRemoteCondition();
        if (link.getLocalState() != EndpointState.CLOSED) {
            link.setCondition(condition);
            link.close();
        }
        this.processOnClose(link, condition);
        this.closeSession(link, condition);
    }
}

