/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.util.HashMap;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.expr.instruct.GlobalParam;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.s9api.ConstructedItemType;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.ItemType;
import net.sf.saxon.s9api.OccurrenceIndicator;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.WhitespaceStrippingPolicy;
import net.sf.saxon.s9api.Xslt30Transformer;
import net.sf.saxon.s9api.XsltTransformer;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.value.SequenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XsltExecutable {
    Processor processor;
    PreparedStylesheet preparedStylesheet;

    protected XsltExecutable(Processor processor, PreparedStylesheet preparedStylesheet) {
        this.processor = processor;
        this.preparedStylesheet = preparedStylesheet;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public XsltTransformer load() {
        return new XsltTransformer(this.processor, this.preparedStylesheet.newController(), this.preparedStylesheet.getCompileTimeParams());
    }

    public Xslt30Transformer load30() {
        String nextInChain = this.preparedStylesheet.getOutputProperties().getProperty("{http://saxon.sf.net/}next-in-chain");
        if (nextInChain != null) {
            this.processor.getUnderlyingConfiguration().getLogger().warning("saxon:next-in-chain is ignored when using an Xslt30Transformer");
        }
        return new Xslt30Transformer(this.processor, this.preparedStylesheet.newController(), this.preparedStylesheet.getCompileTimeParams());
    }

    public void explain(Destination destination) throws SaxonApiException {
        Configuration config = this.processor.getUnderlyingConfiguration();
        this.preparedStylesheet.explain(new ExpressionPresenter(config, destination.getReceiver(config)));
    }

    public WhitespaceStrippingPolicy getWhitespaceStrippingPolicy() {
        return new WhitespaceStrippingPolicy(this.preparedStylesheet);
    }

    public HashMap<QName, ParameterDetails> getGlobalParameters() {
        List<GlobalVariable> globals = this.preparedStylesheet.getCompiledGlobalVariables();
        if (globals == null) {
            return new HashMap<QName, ParameterDetails>(1);
        }
        HashMap<QName, ParameterDetails> params = new HashMap<QName, ParameterDetails>(globals.size());
        for (GlobalVariable v : globals) {
            if (!(v instanceof GlobalParam)) continue;
            ParameterDetails details = new ParameterDetails(v.getRequiredType(), v.isRequiredParam());
            params.put(new QName(v.getVariableQName()), details);
        }
        return params;
    }

    public PreparedStylesheet getUnderlyingCompiledStylesheet() {
        return this.preparedStylesheet;
    }

    public class ParameterDetails {
        private SequenceType type;
        private boolean isRequired;

        protected ParameterDetails(SequenceType type, boolean isRequired) {
            this.type = type;
            this.isRequired = isRequired;
        }

        public ItemType getDeclaredItemType() {
            return new ConstructedItemType(this.type.getPrimaryType(), XsltExecutable.this.processor);
        }

        public OccurrenceIndicator getDeclaredCardinality() {
            return OccurrenceIndicator.getOccurrenceIndicator(this.type.getCardinality());
        }

        public SequenceType getUnderlyingDeclaredType() {
            return this.type;
        }

        public boolean isRequired() {
            return this.isRequired;
        }
    }
}

