/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.xplain;

import java.util.Properties;
import org.apache.derby.impl.sql.catalog.XPLAINScanPropsDescriptor;
import org.apache.derby.impl.sql.catalog.XPLAINSortPropsDescriptor;
import org.apache.derby.shared.common.i18n.MessageService;

public class XPLAINUtil {
    public static final String ISOLATION_READ_UNCOMMITED = "RU";
    public static final String ISOLATION_READ_COMMIT = "RC";
    public static final String ISOLATION_REPEAT_READ = "RR";
    public static final String ISOLATION_SERIALIZABLE = "SE";
    public static final String LOCK_MODE_EXCLUSIVE = "EX";
    public static final String LOCK_MODE_INSTANTENOUS_EXCLUSIVE = "IX";
    public static final String LOCK_MODE_SHARE = "SH";
    public static final String LOCK_MODE_INSTANTENOUS_SHARE = "IS";
    public static final String LOCK_GRANULARITY_TABLE = "T";
    public static final String LOCK_GRANULARITY_ROW = "R";
    public static final String OP_TABLESCAN = "TABLESCAN";
    public static final String OP_INDEXSCAN = "INDEXSCAN";
    public static final String OP_HASHSCAN = "HASHSCAN";
    public static final String OP_DISTINCTSCAN = "DISTINCTSCAN";
    public static final String OP_LASTINDEXKEYSCAN = "LASTINDEXKEYSCAN";
    public static final String OP_HASHTABLE = "HASHTABLE";
    public static final String OP_ROWIDSCAN = "ROWIDSCAN";
    public static final String OP_CONSTRAINTSCAN = "CONSTRAINTSCAN";
    public static final String OP_JOIN_NL = "NLJOIN";
    public static final String OP_JOIN_HASH = "HASHJOIN";
    public static final String OP_JOIN_NL_LO = "LONLJOIN";
    public static final String OP_JOIN_HASH_LO = "LOHASHJOIN";
    public static final String OP_UNION = "UNION";
    public static final String OP_SET = "SET";
    public static final String OP_SET_INTERSECT = "EXCEPT";
    public static final String OP_SET_EXCEPT = "INTERSECT";
    public static final String OP_INSERT = "INSERT";
    public static final String OP_UPDATE = "UPDATE";
    public static final String OP_DELETE = "DELETE";
    public static final String OP_CASCADE = "CASCADE";
    public static final String OP_VTI = "VTI";
    public static final String OP_BULK = "BULK";
    public static final String OP_DISTINCT = "DISTINCT";
    public static final String OP_NORMALIZE = "NORMALIZE";
    public static final String OP_ANY = "ANY";
    public static final String OP_SCROLL = "SCROLL";
    public static final String OP_MATERIALIZE = "MATERIALIZE";
    public static final String OP_ONCE = "ONCE";
    public static final String OP_VTI_RS = "VTI";
    public static final String OP_ROW = "ROW";
    public static final String OP_PROJECT = "PROJECTION";
    public static final String OP_FILTER = "FILTER";
    public static final String OP_AGGREGATE = "AGGREGATION";
    public static final String OP_PROJ_RESTRICT = "PROJECT-FILTER";
    public static final String OP_SORT = "SORT";
    public static final String OP_GROUP = "GROUPBY";
    public static final String OP_CURRENT_OF = "CURRENT-OF";
    public static final String OP_ROW_COUNT = "ROW-COUNT";
    public static final String OP_WINDOW = "WINDOW";
    public static final String SCAN_HEAP = "HEAP";
    public static final String SCAN_BTREE = "BTREE";
    public static final String SCAN_SORT = "SORT";
    public static final String SCAN_BITSET_ALL = "ALL";
    public static final String SELECT_STMT_TYPE = "S";
    public static final String SELECT_APPROXIMATE_STMT_TYPE = "SA";
    public static final String INSERT_STMT_TYPE = "I";
    public static final String UPDATE_STMT_TYPE = "U";
    public static final String DELETE_STMT_TYPE = "D";
    public static final String CALL_STMT_TYPE = "C";
    public static final String DDL_STMT_TYPE = "DDL";
    public static final String XPLAIN_ONLY = "O";
    public static final String XPLAIN_FULL = "F";
    public static final String SORT_EXTERNAL = "EX";
    public static final String SORT_INTERNAL = "IN";
    public static final String YES_CODE = "Y";
    public static final String NO_CODE = "N";

    public static String getYesNoCharFromBoolean(boolean test) {
        if (test) {
            return YES_CODE;
        }
        return NO_CODE;
    }

    public static String getHashKeyColumnNumberString(int[] hashKeyColumns) {
        String hashKeyColumnString;
        if (hashKeyColumns.length == 1) {
            hashKeyColumnString = MessageService.getTextMessage((String)"43X53.U", (Object[])new Object[0]) + " " + hashKeyColumns[0];
        } else {
            hashKeyColumnString = MessageService.getTextMessage((String)"43X54.U", (Object[])new Object[0]) + " (" + hashKeyColumns[0];
            for (int index = 1; index < hashKeyColumns.length; ++index) {
                hashKeyColumnString = hashKeyColumnString + "," + hashKeyColumns[index];
            }
            hashKeyColumnString = hashKeyColumnString + ")";
        }
        return hashKeyColumnString;
    }

    public static String getLockModeCode(String lockString) {
        if ((lockString = lockString.toUpperCase()).startsWith("EXCLUSIVE")) {
            return "EX";
        }
        if (lockString.startsWith("SHARE")) {
            return LOCK_MODE_SHARE;
        }
        if (lockString.startsWith("INSTANTANEOUS")) {
            int length;
            int start = "INSTANTANEOUS".length();
            String sub = lockString.substring(start + 1, length = lockString.length());
            if (sub.startsWith("EXCLUSIVE")) {
                return LOCK_MODE_INSTANTENOUS_EXCLUSIVE;
            }
            if (sub.startsWith("SHARE")) {
                return LOCK_MODE_INSTANTENOUS_SHARE;
            }
            return null;
        }
        return null;
    }

    public static String getIsolationLevelCode(String isolationLevel) {
        if (isolationLevel == null) {
            return null;
        }
        if (isolationLevel.equals(MessageService.getTextMessage((String)"42Z80.U", (Object[])new Object[0]))) {
            return ISOLATION_SERIALIZABLE;
        }
        if (isolationLevel.equals(MessageService.getTextMessage((String)"42Z92", (Object[])new Object[0]))) {
            return ISOLATION_REPEAT_READ;
        }
        if (isolationLevel.equals(MessageService.getTextMessage((String)"42Z81.U", (Object[])new Object[0]))) {
            return ISOLATION_READ_COMMIT;
        }
        if (isolationLevel.equals(MessageService.getTextMessage((String)"42Z9A", (Object[])new Object[0]))) {
            return ISOLATION_READ_UNCOMMITED;
        }
        return null;
    }

    public static String getLockGranularityCode(String lockString) {
        if ((lockString = lockString.toUpperCase()).endsWith("TABLE")) {
            return LOCK_GRANULARITY_TABLE;
        }
        return LOCK_GRANULARITY_ROW;
    }

    public static String getStatementType(String SQLText) {
        String type = "";
        String text = SQLText.toUpperCase().trim();
        if (text.startsWith("CALL")) {
            type = CALL_STMT_TYPE;
        } else if (text.startsWith("SELECT")) {
            type = text.indexOf("~") > -1 ? SELECT_APPROXIMATE_STMT_TYPE : SELECT_STMT_TYPE;
        } else if (text.startsWith(OP_DELETE)) {
            type = DELETE_STMT_TYPE;
        } else if (text.startsWith(OP_INSERT)) {
            type = INSERT_STMT_TYPE;
        } else if (text.startsWith(OP_UPDATE)) {
            type = UPDATE_STMT_TYPE;
        } else if (text.startsWith("CREATE") || text.startsWith("ALTER") || text.startsWith("DROP")) {
            type = DDL_STMT_TYPE;
        }
        return type;
    }

    public static XPLAINScanPropsDescriptor extractScanProps(XPLAINScanPropsDescriptor descriptor, Properties scanProps) {
        String bs_property;
        String bth_property;
        String dvr_property;
        String fc_property;
        String qr_property;
        String vr_property;
        String scan_type = "";
        String scan_type_property = scanProps.getProperty(MessageService.getTextMessage((String)"XSAJ0.U", (Object[])new Object[0]));
        if (scan_type_property != null) {
            if (scan_type_property.equalsIgnoreCase(MessageService.getTextMessage((String)"XSAJG.U", (Object[])new Object[0]))) {
                scan_type = SCAN_HEAP;
            } else if (scan_type_property.equalsIgnoreCase(MessageService.getTextMessage((String)"XSAJH.U", (Object[])new Object[0]))) {
                scan_type = "SORT";
            } else if (scan_type_property.equalsIgnoreCase(MessageService.getTextMessage((String)"XSAJF.U", (Object[])new Object[0]))) {
                scan_type = SCAN_BTREE;
            }
        } else {
            scan_type = null;
        }
        descriptor.setScan_type(scan_type);
        String vp_property = scanProps.getProperty(MessageService.getTextMessage((String)"XSAJ1.U", (Object[])new Object[0]));
        if (vp_property != null) {
            descriptor.setNo_visited_pages(Integer.parseInt(vp_property));
        }
        if ((vr_property = scanProps.getProperty(MessageService.getTextMessage((String)"XSAJ2.U", (Object[])new Object[0]))) != null) {
            descriptor.setNo_visited_rows(Integer.parseInt(vr_property));
        }
        if ((qr_property = scanProps.getProperty(MessageService.getTextMessage((String)"XSAJ4.U", (Object[])new Object[0]))) != null) {
            descriptor.setNo_qualified_rows(Integer.parseInt(qr_property));
        }
        if ((fc_property = scanProps.getProperty(MessageService.getTextMessage((String)"XSAJ5.U", (Object[])new Object[0]))) != null) {
            descriptor.setNo_fetched_columns(Integer.parseInt(fc_property));
        }
        if ((dvr_property = scanProps.getProperty(MessageService.getTextMessage((String)"XSAJ3.U", (Object[])new Object[0]))) != null) {
            descriptor.setNo_visited_deleted_rows(Integer.parseInt(dvr_property));
        }
        if ((bth_property = scanProps.getProperty(MessageService.getTextMessage((String)"XSAJ7.U", (Object[])new Object[0]))) != null) {
            descriptor.setBtree_height(Integer.parseInt(bth_property));
        }
        if ((bs_property = scanProps.getProperty(MessageService.getTextMessage((String)"XSAJ6.U", (Object[])new Object[0]))) != null) {
            if (bs_property.equalsIgnoreCase(MessageService.getTextMessage((String)"XSAJE.U", (Object[])new Object[0]))) {
                descriptor.setBitset_of_fetched_columns(SCAN_BITSET_ALL);
            } else {
                descriptor.setBitset_of_fetched_columns(bs_property);
            }
        }
        return descriptor;
    }

    public static XPLAINSortPropsDescriptor extractSortProps(XPLAINSortPropsDescriptor descriptor, Properties sortProps) {
        String or_property;
        String sort_type = null;
        String sort_type_property = sortProps.getProperty(MessageService.getTextMessage((String)"XSAJ8.U", (Object[])new Object[0]));
        if (sort_type_property != null) {
            sort_type = sort_type_property.equalsIgnoreCase(MessageService.getTextMessage((String)"XSAJI.U", (Object[])new Object[0])) ? "EX" : SORT_INTERNAL;
        }
        descriptor.setSort_type(sort_type);
        String ir_property = sortProps.getProperty(MessageService.getTextMessage((String)"XSAJA.U", (Object[])new Object[0]));
        if (ir_property != null) {
            descriptor.setNo_input_rows(Integer.parseInt(ir_property));
        }
        if ((or_property = sortProps.getProperty(MessageService.getTextMessage((String)"XSAJB.U", (Object[])new Object[0]))) != null) {
            descriptor.setNo_output_rows(Integer.parseInt(or_property));
        }
        if (sort_type == "EX") {
            String nomrd_property;
            String nomr_property = sortProps.getProperty(MessageService.getTextMessage((String)"XSAJC.U", (Object[])new Object[0]));
            if (nomr_property != null) {
                descriptor.setNo_merge_runs(Integer.parseInt(nomr_property));
            }
            if ((nomrd_property = sortProps.getProperty(MessageService.getTextMessage((String)"XSAJD.U", (Object[])new Object[0]))) != null) {
                descriptor.setMerge_run_details(nomrd_property);
            }
        }
        return descriptor;
    }

    public static Long getAVGNextTime(long dividend, long divisor) {
        if (divisor == 0L) {
            return null;
        }
        if (dividend == 0L) {
            return 0L;
        }
        return dividend / divisor;
    }
}

