/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StreamCorruptedException;
import java.util.Vector;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.io.FormatIdUtil;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;
import org.apache.derby.shared.common.util.ArrayUtil;

public class FKInfo
implements Formatable {
    public static final int FOREIGN_KEY = 1;
    public static final int REFERENCED_KEY = 2;
    String schemaName;
    String tableName;
    int type;
    UUID refUUID;
    long refConglomNumber;
    UUID refConstraintID;
    boolean refConstraintIsDeferrable;
    int stmtType;
    RowLocation rowLocation;
    String[] fkConstraintNames;
    private UUID[] fkUUIDs;
    long[] fkConglomNumbers;
    UUID[] fkIds;
    boolean[] fkIsSelfReferencing;
    int[] colArray;
    int[] raRules;
    boolean[] deferrable;

    public FKInfo() {
    }

    public FKInfo(String[] fkConstraintNames, String schemaName, String tableName, int stmtType, int type, UUID refUUID, long refConglomNumber, UUID refConstraintID, boolean refConstraintIsDeferrable, UUID[] fkUUIDs, long[] fkConglomNumbers, boolean[] fkIsSelfReferencing, int[] colArray, RowLocation rowLocation, int[] raRules, boolean[] deferrable, UUID[] fkIds) {
        this.fkConstraintNames = (String[])ArrayUtil.copy((Object[])fkConstraintNames);
        this.tableName = tableName;
        this.schemaName = schemaName;
        this.stmtType = stmtType;
        this.type = type;
        this.refUUID = refUUID;
        this.refConglomNumber = refConglomNumber;
        this.refConstraintID = refConstraintID;
        this.refConstraintIsDeferrable = refConstraintIsDeferrable;
        this.fkUUIDs = (UUID[])ArrayUtil.copy((Object[])fkUUIDs);
        this.fkConglomNumbers = ArrayUtil.copy((long[])fkConglomNumbers);
        this.fkIsSelfReferencing = ArrayUtil.copy((boolean[])fkIsSelfReferencing);
        this.colArray = ArrayUtil.copy((int[])colArray);
        this.rowLocation = rowLocation;
        this.raRules = ArrayUtil.copy((int[])raRules);
        this.deferrable = ArrayUtil.copy((boolean[])deferrable);
        this.fkIds = (UUID[])ArrayUtil.copy((Object[])fkIds);
        if (fkUUIDs.length != fkConglomNumbers.length) {
            SanityManager.THROWASSERT((String)("number of ForeignKey UUIDS (" + fkUUIDs.length + ") doesn't match the number of conglomerate numbers (" + fkConglomNumbers.length + ")"));
        }
        if (type == 1) {
            SanityManager.ASSERT((fkUUIDs.length == 1 ? 1 : 0) != 0, (String)"unexpected number of fkUUIDs for a foreign key, should only have the uuid of the key it references");
        } else if (type == 2) {
            SanityManager.ASSERT((fkUUIDs.length >= 1 ? 1 : 0) != 0, (String)"too few fkUUIDs for a referenced key, expect at least one foreign key");
        } else {
            SanityManager.THROWASSERT((String)("bad type: " + type));
        }
    }

    public static FKInfo[] chooseRelevantFKInfos(FKInfo[] fkInfo, int[] cols, boolean addAllTypeIsFK) {
        if (fkInfo == null) {
            return null;
        }
        Vector<FKInfo> newfksVector = new Vector<FKInfo>();
        FKInfo[] newfks = null;
        for (int i = 0; i < fkInfo.length; ++i) {
            if (addAllTypeIsFK && fkInfo[i].type == 1) {
                newfksVector.addElement(fkInfo[i]);
                continue;
            }
            int fkcollen = fkInfo[i].colArray.length;
            block1: for (int fkCols = 0; fkCols < fkcollen; ++fkCols) {
                for (int chcol = 0; chcol < cols.length; ++chcol) {
                    if (fkInfo[i].colArray[fkCols] != cols[chcol]) continue;
                    newfksVector.addElement(fkInfo[i]);
                    fkCols = fkcollen;
                    continue block1;
                }
            }
        }
        int size = newfksVector.size();
        if (size > 0) {
            newfks = new FKInfo[size];
            for (int i = 0; i < size; ++i) {
                newfks[i] = (FKInfo)newfksVector.elementAt(i);
            }
        }
        return newfks;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        FormatIdUtil.writeFormatIdInteger(out, this.rowLocation.getTypeFormatId());
        out.writeObject(this.schemaName);
        out.writeObject(this.tableName);
        out.writeInt(this.type);
        out.writeInt(this.stmtType);
        out.writeObject(this.refUUID);
        out.writeLong(this.refConglomNumber);
        out.writeObject(this.refConstraintID);
        out.writeBoolean(this.refConstraintIsDeferrable);
        ArrayUtil.writeArray((ObjectOutput)out, (Object[])this.fkConstraintNames);
        ArrayUtil.writeArray((ObjectOutput)out, (Object[])this.fkUUIDs);
        ArrayUtil.writeLongArray((ObjectOutput)out, (long[])this.fkConglomNumbers);
        ArrayUtil.writeBooleanArray((ObjectOutput)out, (boolean[])this.fkIsSelfReferencing);
        ArrayUtil.writeIntArray((ObjectOutput)out, (int[])this.colArray);
        ArrayUtil.writeIntArray((ObjectOutput)out, (int[])this.raRules);
        ArrayUtil.writeBooleanArray((ObjectOutput)out, (boolean[])this.deferrable);
        ArrayUtil.writeArray((ObjectOutput)out, (Object[])this.fkIds);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        try {
            int formatid = FormatIdUtil.readFormatIdInteger(in);
            this.rowLocation = (RowLocation)Monitor.newInstanceFromIdentifier(formatid);
            SanityManager.ASSERT((this.rowLocation != null ? 1 : 0) != 0, (String)"row location is null in readExternal");
            this.schemaName = (String)in.readObject();
            this.tableName = (String)in.readObject();
            this.type = in.readInt();
            this.stmtType = in.readInt();
            this.refUUID = (UUID)in.readObject();
            this.refConglomNumber = in.readLong();
            this.refConstraintID = (UUID)in.readObject();
            this.refConstraintIsDeferrable = in.readBoolean();
            this.fkConstraintNames = new String[ArrayUtil.readArrayLength((ObjectInput)in)];
            ArrayUtil.readArrayItems((ObjectInput)in, (Object[])this.fkConstraintNames);
            this.fkUUIDs = new UUID[ArrayUtil.readArrayLength((ObjectInput)in)];
            ArrayUtil.readArrayItems((ObjectInput)in, (Object[])this.fkUUIDs);
            this.fkConglomNumbers = ArrayUtil.readLongArray((ObjectInput)in);
            this.fkIsSelfReferencing = ArrayUtil.readBooleanArray((ObjectInput)in);
            this.colArray = ArrayUtil.readIntArray((ObjectInput)in);
            this.raRules = ArrayUtil.readIntArray((ObjectInput)in);
            this.deferrable = ArrayUtil.readBooleanArray((ObjectInput)in);
            this.fkIds = new UUID[ArrayUtil.readArrayLength((ObjectInput)in)];
            ArrayUtil.readArrayItems((ObjectInput)in, (Object[])this.fkIds);
        }
        catch (StandardException exception) {
            throw new StreamCorruptedException(exception.toString());
        }
    }

    @Override
    public int getTypeFormatId() {
        return 282;
    }

    public String toString() {
        int i;
        StringBuilder str = new StringBuilder();
        str.append("\nTableName:\t\t\t");
        str.append(this.tableName);
        str.append("\ntype:\t\t\t\t");
        str.append(this.type == 1 ? "FOREIGN_KEY" : "REFERENCED_KEY");
        str.append("\nReferenced Key Index UUID:\t\t" + this.refUUID);
        str.append("\nReferenced Key ConglomNum:\t" + this.refConglomNumber);
        str.append("\nReferenced Key Constraint is deferrable:\t" + this.refConstraintIsDeferrable);
        str.append("\nForeign Key Names:\t\t(");
        for (i = 0; i < this.fkUUIDs.length; ++i) {
            if (i > 0) {
                str.append(",");
            }
            str.append(this.fkConstraintNames[i]);
        }
        str.append(")");
        str.append("\nForeign Key UUIDS:\t\t(");
        for (i = 0; i < this.fkUUIDs.length; ++i) {
            if (i > 0) {
                str.append(",");
            }
            str.append(this.fkUUIDs[i]);
        }
        str.append(")");
        str.append("\nForeign Key Conglom Nums:\t(");
        for (i = 0; i < this.fkConglomNumbers.length; ++i) {
            if (i > 0) {
                str.append(",");
            }
            str.append(this.fkConglomNumbers[i]);
        }
        str.append(")");
        str.append("\nForeign Key isSelfRef:\t\t(");
        for (i = 0; i < this.fkIsSelfReferencing.length; ++i) {
            if (i > 0) {
                str.append(",");
            }
            str.append(this.fkIsSelfReferencing[i]);
        }
        str.append(")");
        str.append("\ncolumn Array:\t\t\t(");
        for (i = 0; i < this.colArray.length; ++i) {
            if (i > 0) {
                str.append(",");
            }
            str.append(this.colArray[i]);
        }
        str.append(")\n");
        str.append("\nDeferrable array:\t\t\t(");
        for (i = 0; i < this.deferrable.length; ++i) {
            if (i > 0) {
                str.append(",");
            }
            str.append(this.colArray[i]);
        }
        str.append(")\n");
        return str.toString();
    }
}

