/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.Ruby;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ForNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.Node;
import org.jruby.ast.PostExeNode;
import org.jruby.ast.PreExeNode;
import org.jruby.ast.RestArgNode;
import org.jruby.ast.StarNode;
import org.jruby.ast.UnnamedRestArgNode;
import org.jruby.runtime.Arity;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.TypeConverter;

public class Signature {
    public static final Signature NO_ARGUMENTS = new Signature(0, 0, 0, Rest.NONE, 0, 0, -1);
    public static final Signature ONE_ARGUMENT = new Signature(1, 0, 0, Rest.NONE, 0, 0, -1);
    public static final Signature TWO_ARGUMENTS = new Signature(2, 0, 0, Rest.NONE, 0, 0, -1);
    public static final Signature THREE_ARGUMENTS = new Signature(3, 0, 0, Rest.NONE, 0, 0, -1);
    public static final Signature FOUR_ARGUMENTS = new Signature(4, 0, 0, Rest.NONE, 0, 0, -1);
    public static final Signature OPTIONAL = new Signature(0, 0, 0, Rest.NORM, 0, 0, -1);
    public static final Signature ONE_REQUIRED = new Signature(1, 0, 0, Rest.NORM, 0, 0, -1);
    public static final Signature TWO_REQUIRED = new Signature(2, 0, 0, Rest.NORM, 0, 0, -1);
    public static final Signature THREE_REQUIRED = new Signature(3, 0, 0, Rest.NORM, 0, 0, -1);
    public static final Signature FOUR_REQUIRED = new Signature(4, 0, 0, Rest.NORM, 0, 0, -1);
    public static final Signature ONE_OPT_ARGUMENT = new Signature(0, 1, 0, Rest.NONE, 0, 0, -1);
    private final short pre;
    private final short opt;
    private final Rest rest;
    private final short post;
    private final short kwargs;
    private final short requiredKwargs;
    private final int arityValue;
    private final int keyRest;
    private static final int MAX_ENCODED_ARGS_EXPONENT = 8;
    private static final int MAX_ENCODED_ARGS_MASK = 255;
    private static final int ENCODE_RESTKWARGS_SHIFT = 0;
    private static final int ENCODE_REST_SHIFT = 8;
    private static final int ENCODE_REQKWARGS_SHIFT = 16;
    private static final int ENCODE_KWARGS_SHIFT = 24;
    private static final int ENCODE_POST_SHIFT = 32;
    private static final int ENCODE_OPT_SHIFT = 40;
    private static final int ENCODE_PRE_SHIFT = 48;

    public Signature(int pre, int opt, int post, Rest rest, int kwargs, int requiredKwargs, int keyRest) {
        this.pre = (short)pre;
        this.opt = (short)opt;
        this.post = (short)post;
        this.rest = rest;
        this.kwargs = (short)kwargs;
        this.requiredKwargs = (short)requiredKwargs;
        this.keyRest = keyRest;
        this.arityValue = this.calculateArityValue();
    }

    public int getRequiredKeywordForArityCount() {
        return this.requiredKwargs > 0 ? 1 : 0;
    }

    public boolean restKwargs() {
        return this.keyRest != -1;
    }

    public int pre() {
        return this.pre;
    }

    public int opt() {
        return this.opt;
    }

    public Rest rest() {
        return this.rest;
    }

    public int post() {
        return this.post;
    }

    public boolean hasKwargs() {
        return this.kwargs > 0 || this.restKwargs();
    }

    public boolean hasRest() {
        return this.rest != Rest.NONE;
    }

    public int keyRest() {
        return this.keyRest;
    }

    public boolean isFixed() {
        return this.arityValue() >= 0 && this.rest != Rest.ANON;
    }

    public boolean isNoArguments() {
        return this.isFixed() && this.required() == 0;
    }

    public boolean isOneArgument() {
        return this.isFixed() && this.required() == 1;
    }

    public boolean isTwoArguments() {
        return this.isFixed() && this.required() == 2;
    }

    public int required() {
        return this.pre + this.post;
    }

    @Deprecated
    public Arity arity() {
        if (this.rest != Rest.NONE || this.opt != 0) {
            return Arity.createArity(-(this.required() + 1));
        }
        return Arity.fixed(this.required() + this.getRequiredKeywordForArityCount());
    }

    public int calculateArityValue() {
        boolean optionalFromRest;
        int oneForKeywords = this.requiredKwargs > 0 ? 1 : 0;
        int fixedValue = this.pre() + this.post() + oneForKeywords;
        boolean hasOptionalKeywords = this.kwargs - this.requiredKwargs > 0;
        boolean bl = optionalFromRest = this.rest() != Rest.NONE && this.rest != Rest.ANON;
        if (this.opt() > 0 || optionalFromRest || (hasOptionalKeywords || this.restKwargs()) && oneForKeywords == 0) {
            return -1 * (fixedValue + 1);
        }
        return fixedValue;
    }

    public int arityValue() {
        return this.arityValue;
    }

    public boolean isSpreadable() {
        return this.arityValue < -1 || this.arityValue > 1 || this.opt > 0 && !this.restKwargs() || this.rest == Rest.ANON;
    }

    public static Signature fromArityValue(int arityValue) {
        boolean negative = arityValue < 0;
        int value2 = negative ? -1 * arityValue - 1 : arityValue;
        switch (value2) {
            case 0: {
                return negative ? OPTIONAL : NO_ARGUMENTS;
            }
            case 1: {
                return negative ? ONE_REQUIRED : ONE_ARGUMENT;
            }
            case 2: {
                return negative ? TWO_REQUIRED : TWO_ARGUMENTS;
            }
            case 3: {
                return negative ? THREE_REQUIRED : THREE_ARGUMENTS;
            }
        }
        throw new UnsupportedOperationException("We do not know enough about the arity to convert it to a signature");
    }

    @Deprecated
    public static Signature from(Arity arity2) {
        switch (arity2.required()) {
            case 0: {
                return arity2.isFixed() ? NO_ARGUMENTS : OPTIONAL;
            }
            case 1: {
                return arity2.isFixed() ? ONE_ARGUMENT : ONE_REQUIRED;
            }
            case 2: {
                return arity2.isFixed() ? TWO_ARGUMENTS : TWO_REQUIRED;
            }
            case 3: {
                return arity2.isFixed() ? THREE_ARGUMENTS : THREE_REQUIRED;
            }
        }
        throw new UnsupportedOperationException("We do not know enough about the arity to convert it to a signature");
    }

    public static Signature from(int pre, int opt, int post, int kwargs, int requiredKwargs, Rest rest, int keyRest) {
        if (opt == 0 && post == 0 && kwargs == 0 && keyRest == -1) {
            switch (pre) {
                case 0: {
                    switch (rest) {
                        case NONE: {
                            return NO_ARGUMENTS;
                        }
                        case NORM: {
                            return OPTIONAL;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (rest) {
                        case NONE: {
                            return ONE_ARGUMENT;
                        }
                        case NORM: {
                            return ONE_REQUIRED;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (rest) {
                        case NONE: {
                            return TWO_ARGUMENTS;
                        }
                        case NORM: {
                            return TWO_REQUIRED;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (rest) {
                        case NONE: {
                            return THREE_ARGUMENTS;
                        }
                        case NORM: {
                            return THREE_REQUIRED;
                        }
                    }
                    break;
                }
                case 4: {
                    switch (rest) {
                        case NONE: {
                            return FOUR_ARGUMENTS;
                        }
                        case NORM: {
                            return FOUR_REQUIRED;
                        }
                    }
                }
            }
        } else if (opt == 1 && pre == 0 && rest == Rest.NONE && post == 0 && kwargs == 0 && keyRest == -1) {
            return ONE_OPT_ARGUMENT;
        }
        return new Signature(pre, opt, post, rest, kwargs, requiredKwargs, keyRest);
    }

    public static Signature from(ArgsNode args2) {
        RestArgNode restArg = args2.getRestArgNode();
        Rest rest = restArg != null ? Signature.restFromArg(restArg) : Rest.NONE;
        return Signature.from(args2.getPreCount(), args2.getOptionalArgsCount(), args2.getPostCount(), args2.getKeywordCount(), args2.getRequiredKeywordCount(), rest, args2.hasKeyRest() ? args2.getKeyRest().getIndex() : -1);
    }

    public static Signature from(IterNode iter) {
        if (iter instanceof ForNode) {
            return Signature.from((ForNode)iter);
        }
        if (iter instanceof PreExeNode) {
            return Signature.from((PreExeNode)iter);
        }
        if (iter instanceof PostExeNode) {
            return Signature.from((PostExeNode)iter);
        }
        return Signature.from((ArgsNode)iter.getVarNode());
    }

    private static Rest restFromArg(Node restArg) {
        UnnamedRestArgNode anonRest;
        Rest rest = restArg instanceof UnnamedRestArgNode ? ((anonRest = (UnnamedRestArgNode)restArg).isStar() ? Rest.STAR : Rest.ANON) : (restArg instanceof StarNode ? Rest.STAR : Rest.NORM);
        return rest;
    }

    public static Signature from(ForNode iter) {
        Node var = iter.getVarNode();
        if (var instanceof MultipleAsgnNode) {
            MultipleAsgnNode masgn = (MultipleAsgnNode)var;
            Rest rest = masgn.getRest() == null ? Rest.NONE : Signature.restFromArg(masgn.getRest());
            int argCount = masgn.getPreCount();
            if (rest == Rest.NONE && argCount == 1) {
                argCount = 2;
            }
            return Signature.from(argCount, 0, 0, 0, 0, rest, -1);
        }
        return ONE_ARGUMENT;
    }

    public static Signature from(PreExeNode iter) {
        return NO_ARGUMENTS;
    }

    public static Signature from(PostExeNode iter) {
        return NO_ARGUMENTS;
    }

    public long encode() {
        return (long)this.pre << 48 | (long)this.opt << 40 | (long)this.post << 32 | (long)this.kwargs << 24 | (long)this.requiredKwargs << 16 | (long)(this.rest.ordinal() << 8) | (long)((this.keyRest & 0xFF) << 0);
    }

    public static Signature decode(long l) {
        return Signature.from((int)(l >>> 48) & 0xFF, (int)(l >>> 40) & 0xFF, (int)(l >>> 32) & 0xFF, (int)(l >>> 24) & 0xFF, (int)(l >>> 16) & 0xFF, Rest.fromOrdinal((int)(l >>> 8 & 0xFFL)), (byte)(l >>> 0 & 0xFFL));
    }

    public String toString() {
        return "signature(pre=" + this.pre + ",opt=" + this.opt + ",post=" + this.post + ",rest=" + (Object)((Object)this.rest) + ",kwargs=" + this.kwargs + ",kwreq=" + this.requiredKwargs + ",kwrest=" + this.keyRest + ")";
    }

    public void checkArity(Ruby runtime2, IRubyObject[] args2) {
        if (args2.length < this.required()) {
            throw runtime2.newArgumentError(args2.length, this.required(), this.hasRest() ? -1 : this.required() + this.opt);
        }
        if ((this.rest == Rest.NONE || this.rest == Rest.ANON) && args2.length > this.required() + this.opt()) {
            if (this.hasKwargs() && !TypeConverter.checkHashType(runtime2, args2[args2.length - 1]).isNil()) {
                if (args2.length - 1 > this.required() + this.opt()) {
                    throw runtime2.newArgumentError(args2.length, this.required(), this.hasRest() ? -1 : this.required() + this.opt);
                }
            } else {
                throw runtime2.newArgumentError(args2.length, this.required(), this.hasRest() ? -1 : this.required() + this.opt);
            }
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof Signature)) {
            return false;
        }
        Signature otherSig = (Signature)other;
        return this.pre == otherSig.pre && this.opt == otherSig.opt && this.post == otherSig.post && this.rest == otherSig.rest && this.kwargs == otherSig.kwargs && this.requiredKwargs == otherSig.requiredKwargs && this.keyRest == otherSig.keyRest;
    }

    public int hashCode() {
        return this.rest.hashCode() + this.pre * 3 + this.opt * 5 + this.post * 7 + this.kwargs * 11 + this.requiredKwargs * 13 + this.arityValue * 17 + this.keyRest * 19;
    }

    public static enum Rest {
        NONE,
        NORM,
        ANON,
        STAR;

        private static final Rest[] VALUES;

        public static Rest fromOrdinal(int ordinal2) {
            if (ordinal2 < 0 || ordinal2 >= VALUES.length) {
                throw new RuntimeException("invalid Rest: " + ordinal2);
            }
            return VALUES[ordinal2];
        }

        static {
            VALUES = Rest.values();
        }
    }
}

