/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ClientProxy;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.InjectableInstance;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.WithCaching;
import io.quarkus.arc.impl.ArcContainerImpl;
import io.quarkus.arc.impl.CreationalContextImpl;
import io.quarkus.arc.impl.InjectionPointImpl;
import io.quarkus.arc.impl.InjectionPointProvider;
import io.quarkus.arc.impl.Instances;
import io.quarkus.arc.impl.LazyInstanceHandle;
import io.quarkus.arc.impl.LazyValue;
import io.quarkus.arc.impl.SingletonContext;
import io.quarkus.arc.impl.TypeCachePollutionUtils;
import io.quarkus.arc.impl.Types;
import jakarta.enterprise.context.ContextNotActiveException;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.inject.AmbiguousResolutionException;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.UnsatisfiedResolutionException;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.util.TypeLiteral;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

public class InstanceImpl<T>
implements InjectableInstance<T> {
    private final CreationalContextImpl<?> creationalContext;
    private final List<InjectableBean<?>> resolvedBeans;
    private final Type requiredType;
    private final Set<Annotation> requiredQualifiers;
    private final Type injectionPointType;
    private final InjectableBean<?> targetBean;
    private final Set<Annotation> annotations;
    private final Member javaMember;
    private final int position;
    private final boolean isTransient;
    private final boolean resetCurrentInjectionPoint;
    private final LazyValue<T> cachedGetResult;

    public static Instance<Object> forSynthesis(CreationalContextImpl<?> creationalContext, boolean allowInjectionPointLookup) {
        InstanceImpl<Object> result = new InstanceImpl<Object>(creationalContext, (Type)((Object)Object.class), Collections.emptySet(), null, null, Collections.emptySet(), null, -1, false, false);
        if (allowInjectionPointLookup) {
            return result;
        }
        class Guard<T>
        implements InjectableInstance<T> {
            private final InjectableInstance<T> delegate;

            Guard(InjectableInstance<T> delegate) {
                this.delegate = delegate;
            }

            @Override
            public InstanceHandle<T> getHandle() {
                return this.delegate.getHandle();
            }

            @Override
            public Iterable<InstanceHandle<T>> handles() {
                return this.delegate.handles();
            }

            @Override
            public InjectableInstance<T> select(Annotation ... qualifiers) {
                return this.wrap(null, (InjectableInstance)this.delegate.select(qualifiers));
            }

            @Override
            public <U extends T> InjectableInstance<U> select(Class<U> subtype, Annotation ... qualifiers) {
                return this.wrap(subtype, (InjectableInstance<U>)this.delegate.select((Class)subtype, qualifiers));
            }

            @Override
            public <U extends T> InjectableInstance<U> select(TypeLiteral<U> subtype, Annotation ... qualifiers) {
                return this.wrap(subtype.getType(), (InjectableInstance<U>)this.delegate.select((TypeLiteral)subtype, qualifiers));
            }

            private <U> InjectableInstance<U> wrap(Type subtype, InjectableInstance<U> delegate) {
                if (InjectionPoint.class.equals((Object)subtype)) {
                    throw new IllegalStateException("Cannot obtain InjectionPoint metadata for non-@Dependent bean");
                }
                return new Guard<U>(delegate);
            }

            @Override
            public void clearCache() {
                this.delegate.clearCache();
            }

            @Override
            public Iterator<T> iterator() {
                return this.delegate.iterator();
            }

            public boolean isUnsatisfied() {
                return this.delegate.isUnsatisfied();
            }

            public boolean isAmbiguous() {
                return this.delegate.isAmbiguous();
            }

            public void destroy(T instance) {
                this.delegate.destroy(instance);
            }

            public T get() {
                return (T)this.delegate.get();
            }
        }
        return new Guard<Object>(result);
    }

    static <T> InstanceImpl<T> forGlobalEntrypoint(Type requiredType, Set<Annotation> requiredQualifiers) {
        return new InstanceImpl<T>(new CreationalContextImpl(null), requiredType, requiredQualifiers, null, null, Collections.emptySet(), null, -1, false, true);
    }

    static <T> InstanceImpl<T> forInjection(InjectableBean<?> targetBean, Type type, Set<Annotation> qualifiers, CreationalContextImpl<?> creationalContext, Set<Annotation> annotations, Member javaMember, int position, boolean isTransient) {
        return new InstanceImpl<T>(creationalContext, InstanceImpl.getRequiredType(type), qualifiers, type, targetBean, annotations, javaMember, position, isTransient, true);
    }

    private static <T> InstanceImpl<T> child(InstanceImpl<?> parent, Type requiredType, Set<Annotation> requiredQualifiers) {
        return new InstanceImpl<T>(parent.creationalContext, requiredType, requiredQualifiers, parent.injectionPointType, parent.targetBean, parent.annotations, parent.javaMember, parent.position, parent.isTransient, parent.resetCurrentInjectionPoint);
    }

    private InstanceImpl(CreationalContextImpl<?> creationalContext, Type requiredType, Set<Annotation> requiredQualifiers, Type injectionPointType, InjectableBean<?> targetBean, Set<Annotation> annotations, Member javaMember, int position, boolean isTransient, boolean resetCurrentInjectionPoint) {
        this.creationalContext = creationalContext;
        this.requiredType = requiredType;
        this.requiredQualifiers = requiredQualifiers != null ? requiredQualifiers : Collections.emptySet();
        this.resolvedBeans = this.requiredQualifiers.isEmpty() && Object.class.equals((Object)requiredType) ? null : this.resolve();
        this.injectionPointType = injectionPointType;
        this.targetBean = targetBean;
        this.annotations = annotations;
        this.javaMember = javaMember;
        this.position = position;
        this.isTransient = isTransient;
        this.resetCurrentInjectionPoint = resetCurrentInjectionPoint;
        this.cachedGetResult = this.isGetCached(annotations) ? new LazyValue<Object>(this::getInternal) : null;
    }

    @Override
    public Iterator<T> iterator() {
        return new InstanceIterator(this.beans());
    }

    public T get() {
        return this.cachedGetResult != null ? this.cachedGetResult.get() : this.getInternal();
    }

    @Override
    public InjectableInstance<T> select(Annotation ... qualifiers) {
        HashSet<Annotation> newQualifiers = new HashSet<Annotation>(this.requiredQualifiers);
        Collections.addAll(newQualifiers, qualifiers);
        return InstanceImpl.child(this, this.requiredType, newQualifiers);
    }

    @Override
    public <U extends T> InjectableInstance<U> select(Class<U> subtype, Annotation ... qualifiers) {
        HashSet<Annotation> newQualifiers = new HashSet<Annotation>(this.requiredQualifiers);
        Collections.addAll(newQualifiers, qualifiers);
        return InstanceImpl.child(this, subtype, newQualifiers);
    }

    @Override
    public <U extends T> InjectableInstance<U> select(TypeLiteral<U> subtype, Annotation ... qualifiers) {
        HashSet<Annotation> newQualifiers = new HashSet<Annotation>(this.requiredQualifiers);
        Collections.addAll(newQualifiers, qualifiers);
        return InstanceImpl.child(this, subtype.getType(), newQualifiers);
    }

    public boolean isUnsatisfied() {
        return this.beans().isEmpty();
    }

    public boolean isAmbiguous() {
        return this.beans().size() > 1;
    }

    public void destroy(Object instance) {
        Objects.requireNonNull(instance);
        if (instance instanceof ClientProxy) {
            ClientProxy proxy = (ClientProxy)instance;
            InjectableContext context = Arc.container().getActiveContext(proxy.arc_bean().getScope());
            if (context == null) {
                throw new ContextNotActiveException("No active context found for: " + proxy.arc_bean().getScope());
            }
            context.destroy((Contextual)proxy.arc_bean());
        } else if (!this.creationalContext.removeDependentInstance(instance, true)) {
            SingletonContext singletonContext = (SingletonContext)Arc.container().getActiveContext(Singleton.class);
            singletonContext.destroyInstance(instance);
        }
    }

    @Override
    public InstanceHandle<T> getHandle() {
        return this.getHandle(this.bean());
    }

    @Override
    public Iterable<InstanceHandle<T>> handles() {
        return new Iterable<InstanceHandle<T>>(){

            @Override
            public Iterator<InstanceHandle<T>> iterator() {
                return new InstanceHandlesIterator(InstanceImpl.this.beans());
            }
        };
    }

    private <H> InstanceHandle<H> getHandle(final InjectableBean<H> bean) {
        final CreationalContextImpl<H> context = this.creationalContext.child(bean);
        return new LazyInstanceHandle<Object>(bean, context, this.creationalContext, new Supplier<H>(){

            @Override
            public H get() {
                InjectionPoint prev = null;
                if (InstanceImpl.this.resetCurrentInjectionPoint) {
                    prev = InjectionPointProvider.set(new InjectionPointImpl(InstanceImpl.this.injectionPointType, InstanceImpl.this.requiredType, InstanceImpl.this.requiredQualifiers, InstanceImpl.this.targetBean, InstanceImpl.this.annotations, InstanceImpl.this.javaMember, InstanceImpl.this.position, InstanceImpl.this.isTransient));
                }
                try {
                    Object object = bean.get(context);
                    return object;
                }
                finally {
                    if (InstanceImpl.this.resetCurrentInjectionPoint) {
                        InjectionPointProvider.set(prev);
                    }
                }
            }
        }, Dependent.class.equals(bean.getScope()) ? this::destroy : null);
    }

    private InjectableBean<T> bean() {
        List<InjectableBean<?>> beans = this.beans();
        if (beans.isEmpty()) {
            ArcContainerImpl.instance().scanRemovedBeans(this.requiredType, this.requiredQualifiers.toArray(new Annotation[0]));
            throw new UnsatisfiedResolutionException("No bean found for required type [" + this.requiredType + "] and qualifiers [" + this.requiredQualifiers + "]");
        }
        if (beans.size() > 1) {
            throw new AmbiguousResolutionException("Beans: " + beans.toString());
        }
        return beans.iterator().next();
    }

    public boolean hasDependentInstances() {
        return this.creationalContext.hasDependentInstances();
    }

    @Override
    public void clearCache() {
        if (this.cachedGetResult.isSet()) {
            this.creationalContext.release();
            this.cachedGetResult.clear();
        }
    }

    private T getInternal() {
        return this.getBeanInstance(this.bean());
    }

    void destroy() {
        this.creationalContext.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T getBeanInstance(InjectableBean<T> bean) {
        Object instance;
        CreationalContextImpl<T> ctx = this.creationalContext.child(bean);
        InjectionPoint prev = null;
        if (this.resetCurrentInjectionPoint) {
            prev = InjectionPointProvider.set(new InjectionPointImpl(this.injectionPointType, this.requiredType, this.requiredQualifiers, this.targetBean, this.annotations, this.javaMember, this.position, this.isTransient));
        }
        try {
            instance = bean.get(ctx);
        }
        finally {
            if (this.resetCurrentInjectionPoint) {
                InjectionPointProvider.set(prev);
            }
        }
        return (T)instance;
    }

    private List<InjectableBean<?>> beans() {
        return this.resolvedBeans != null ? this.resolvedBeans : this.resolve();
    }

    private List<InjectableBean<?>> resolve() {
        return Instances.resolveBeans(this.requiredType, this.requiredQualifiers);
    }

    private static Type getRequiredType(Type type) {
        ParameterizedType parameterizedType;
        if (TypeCachePollutionUtils.isParameterizedType(type) && Provider.class.isAssignableFrom(Types.getRawType((parameterizedType = TypeCachePollutionUtils.asParameterizedType(type)).getRawType()))) {
            return parameterizedType.getActualTypeArguments()[0];
        }
        throw new IllegalArgumentException("Not a valid type: " + type);
    }

    private boolean isGetCached(Set<Annotation> annotations) {
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().equals(WithCaching.class)) continue;
            return true;
        }
        return false;
    }

    class InstanceIterator
    implements Iterator<T> {
        protected final Iterator<InjectableBean<?>> delegate;

        private InstanceIterator(Collection<InjectableBean<?>> beans) {
            this.delegate = beans.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public T next() {
            return InstanceImpl.this.getBeanInstance(this.delegate.next());
        }
    }

    private class InstanceHandlesIterator<H>
    implements Iterator<InstanceHandle<H>> {
        final Iterator<InjectableBean<?>> delegate;

        InstanceHandlesIterator(Collection<InjectableBean<?>> beans) {
            this.delegate = beans.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public InstanceHandle<H> next() {
            return InstanceImpl.this.getHandle(this.delegate.next());
        }
    }
}

