/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.credential.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import org.keycloak.common.util.MultivaluedHashMap;

public class PasswordCredentialData {
    private final int hashIterations;
    private final String algorithm;
    private MultivaluedHashMap<String, String> additionalParameters;

    public PasswordCredentialData(int hashIterations, String algorithm) {
        this(hashIterations, algorithm, null);
    }

    @JsonCreator
    public PasswordCredentialData(@JsonProperty(value="hashIterations") int hashIterations, @JsonProperty(value="algorithm") String algorithm, @JsonProperty(value="algorithmData") Map<String, List<String>> additionalParameters) {
        this.hashIterations = hashIterations;
        this.algorithm = algorithm;
        this.additionalParameters = additionalParameters != null ? new MultivaluedHashMap(additionalParameters) : null;
    }

    public int getHashIterations() {
        return this.hashIterations;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public MultivaluedHashMap<String, String> getAdditionalParameters() {
        if (this.additionalParameters == null) {
            this.additionalParameters = new MultivaluedHashMap();
        }
        return this.additionalParameters;
    }
}

