/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.narayana;

import io.agroal.api.transaction.TransactionIntegration;
import io.agroal.narayana.XAExceptionUtils;
import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.tm.XAResourceWrapper;

public class RecoveryXAResource
implements AutoCloseable,
XAResourceWrapper {
    private static final String PRODUCT_NAME = RecoveryXAResource.class.getPackage().getImplementationTitle();
    private static final String PRODUCT_VERSION = RecoveryXAResource.class.getPackage().getImplementationVersion();
    private final TransactionIntegration.ResourceRecoveryFactory connectionFactory;
    private final String jndiName;
    private XAConnection xaConnection;
    private XAResource wrappedResource;

    public RecoveryXAResource(TransactionIntegration.ResourceRecoveryFactory factory, String name) throws SQLException {
        this.connectionFactory = factory;
        this.jndiName = name;
        this.connect(false);
    }

    private boolean connect(boolean flag) throws SQLException {
        if (this.wrappedResource == null) {
            this.xaConnection = this.connectionFactory.getRecoveryConnection();
            this.wrappedResource = this.xaConnection.getXAResource();
            return flag;
        }
        return false;
    }

    private <R> R getConnectedResource(Function<XAResource, R> f) throws XAException {
        boolean reconnect = false;
        try {
            reconnect = this.connect(true);
            R r = f.apply(this.wrappedResource);
            return r;
        }
        catch (SQLException e) {
            throw XAExceptionUtils.xaException(-7, e);
        }
        finally {
            if (reconnect) {
                this.close();
            }
        }
    }

    public Xid[] recover(int flag) throws XAException {
        try {
            if (flag == 0x1000000) {
                this.connect(false);
            }
            Xid[] value = this.getConnectedResource(xaResource -> xaResource.recover(flag));
            if (flag == 0x800000 && (value == null || value.length == 0)) {
                this.close();
            }
            return value;
        }
        catch (SQLException e) {
            throw XAExceptionUtils.xaException(-7, e);
        }
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        this.getConnectedResource(xaResource -> {
            xaResource.commit(xid, onePhase);
            return null;
        });
    }

    public void end(Xid xid, int flags) throws XAException {
        this.getConnectedResource(xaResource -> {
            xaResource.end(xid, flags);
            return null;
        });
    }

    public void forget(Xid xid) throws XAException {
        this.getConnectedResource(xaResource -> {
            xaResource.forget(xid);
            return null;
        });
    }

    public int getTransactionTimeout() throws XAException {
        return this.getConnectedResource(XAResource::getTransactionTimeout);
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        return this.getConnectedResource(xaResource -> xaResource.isSameRM(xares));
    }

    public int prepare(Xid xid) throws XAException {
        return this.getConnectedResource(xaResource -> xaResource.prepare(xid));
    }

    public void rollback(Xid xid) throws XAException {
        this.getConnectedResource(xaResource -> {
            xaResource.rollback(xid);
            return null;
        });
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return this.getConnectedResource(xaResource -> xaResource.setTransactionTimeout(seconds));
    }

    public void start(Xid xid, int flags) throws XAException {
        this.getConnectedResource(xaResource -> {
            xaResource.start(xid, flags);
            return null;
        });
    }

    @Override
    public void close() throws XAException {
        try {
            this.xaConnection.close();
        }
        catch (SQLException e) {
            throw XAExceptionUtils.xaException(-7, e);
        }
        finally {
            this.xaConnection = null;
            this.wrappedResource = null;
        }
    }

    public XAResource getResource() {
        return this.wrappedResource;
    }

    public String getProductName() {
        return PRODUCT_NAME;
    }

    public String getProductVersion() {
        return PRODUCT_VERSION;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    private static interface Function<T, R> {
        public R apply(T var1) throws XAException;
    }
}

