/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.graph;

import java.util.ArrayList;
import java.util.List;
import org.rrd4j.graph.CommentText;
import org.rrd4j.graph.ImageWorker;
import org.rrd4j.graph.LegendText;
import org.rrd4j.graph.Markers;
import org.rrd4j.graph.RrdGraph;
import org.rrd4j.graph.RrdGraphConstants;
import org.rrd4j.graph.RrdGraphDef;

class LegendComposer
implements RrdGraphConstants {
    private final RrdGraphDef gdef;
    private final ImageWorker worker;
    private final int legX;
    private int legY;
    private final int legWidth;
    private final double interLegendSpace;
    private final double leading;
    private final double smallLeading;
    private final double boxSpace;

    LegendComposer(RrdGraph rrdGraph, int legX, int legY, int legWidth) {
        this.gdef = rrdGraph.gdef;
        this.worker = rrdGraph.worker;
        this.legX = legX;
        this.legY = legY;
        this.legWidth = legWidth;
        this.interLegendSpace = rrdGraph.getInterlegendSpace();
        this.leading = rrdGraph.getLeading();
        this.smallLeading = rrdGraph.getSmallLeading();
        this.boxSpace = rrdGraph.getBoxSpace();
    }

    int placeComments() {
        Line line = new Line();
        for (CommentText comment : this.gdef.comments) {
            if (!comment.isValidGraphElement()) continue;
            if (!line.canAccommodate(comment)) {
                line.layoutAndAdvance(false);
                line.clear();
            }
            line.add(comment);
        }
        line.layoutAndAdvance(true);
        return this.legY;
    }

    class Line {
        private Markers lastMarker;
        private double width;
        private int spaceCount;
        private boolean noJustification;
        private final List<CommentText> comments = new ArrayList<CommentText>();

        Line() {
            this.clear();
        }

        void clear() {
            this.lastMarker = null;
            this.width = 0.0;
            this.spaceCount = 0;
            this.noJustification = false;
            this.comments.clear();
        }

        boolean canAccommodate(CommentText comment) {
            if (this.comments.size() == 0) {
                return true;
            }
            if (this.lastMarker == Markers.ALIGN_LEFT_MARKER || this.lastMarker == Markers.ALIGN_LEFTNONL_MARKER || this.lastMarker == Markers.ALIGN_CENTER_MARKER || this.lastMarker == Markers.ALIGN_RIGHT_MARKER || this.lastMarker == Markers.ALIGN_JUSTIFIED_MARKER || this.lastMarker == Markers.VERTICAL_SPACING_MARKER) {
                return false;
            }
            double commentWidth = this.getCommentWidth(comment);
            if (this.lastMarker != Markers.GLUE_MARKER) {
                commentWidth += LegendComposer.this.interLegendSpace;
            }
            return this.width + commentWidth <= (double)LegendComposer.this.legWidth;
        }

        void add(CommentText comment) {
            double commentWidth = this.getCommentWidth(comment);
            if (this.comments.size() > 0 && this.lastMarker != Markers.GLUE_MARKER) {
                commentWidth += LegendComposer.this.interLegendSpace;
                ++this.spaceCount;
            }
            this.width += commentWidth;
            this.lastMarker = comment.marker;
            this.noJustification |= this.lastMarker == Markers.NO_JUSTIFICATION_MARKER || this.lastMarker == null;
            this.comments.add(comment);
        }

        void layoutAndAdvance(boolean isLastLine) {
            if (this.comments.size() > 0) {
                if (this.lastMarker == Markers.ALIGN_LEFT_MARKER || this.lastMarker == Markers.ALIGN_LEFTNONL_MARKER) {
                    this.placeComments(LegendComposer.this.legX, LegendComposer.this.interLegendSpace);
                } else if (this.lastMarker == Markers.ALIGN_RIGHT_MARKER) {
                    this.placeComments((double)(LegendComposer.this.legX + LegendComposer.this.legWidth) - this.width, LegendComposer.this.interLegendSpace);
                } else if (this.lastMarker == Markers.ALIGN_CENTER_MARKER) {
                    this.placeComments((double)LegendComposer.this.legX + ((double)LegendComposer.this.legWidth - this.width) / 2.0, LegendComposer.this.interLegendSpace);
                } else if (this.lastMarker == Markers.ALIGN_JUSTIFIED_MARKER) {
                    if (this.spaceCount > 0) {
                        this.placeComments(LegendComposer.this.legX, ((double)LegendComposer.this.legWidth - this.width) / (double)this.spaceCount + LegendComposer.this.interLegendSpace);
                    } else {
                        this.placeComments(LegendComposer.this.legX, LegendComposer.this.interLegendSpace);
                    }
                } else if (this.lastMarker == Markers.VERTICAL_SPACING_MARKER) {
                    this.placeComments(LegendComposer.this.legX, LegendComposer.this.interLegendSpace);
                } else if (this.noJustification || isLastLine) {
                    this.placeComments(LegendComposer.this.legX, ((double)LegendComposer.this.legWidth - this.width) / (double)this.spaceCount + LegendComposer.this.interLegendSpace);
                } else {
                    this.placeComments(LegendComposer.this.legX, LegendComposer.this.interLegendSpace);
                }
                if (this.lastMarker != Markers.ALIGN_LEFTNONL_MARKER) {
                    if (this.lastMarker == Markers.VERTICAL_SPACING_MARKER) {
                        LegendComposer.this.legY = (int)((double)LegendComposer.this.legY + LegendComposer.this.smallLeading);
                    } else {
                        LegendComposer.this.legY = (int)((double)LegendComposer.this.legY + LegendComposer.this.leading);
                    }
                }
            }
        }

        private double getCommentWidth(CommentText comment) {
            double commentWidth = LegendComposer.this.worker.getStringWidth(comment.resolvedText, LegendComposer.this.gdef.getFont(RrdGraphConstants.FONTTAG_LEGEND));
            if (comment instanceof LegendText) {
                commentWidth += LegendComposer.this.boxSpace;
            }
            return commentWidth;
        }

        private void placeComments(double xStart, double space) {
            double x = xStart;
            for (CommentText comment : this.comments) {
                comment.x = (int)x;
                comment.y = LegendComposer.this.legY;
                x += this.getCommentWidth(comment);
                if (comment.marker == Markers.GLUE_MARKER) continue;
                x += space;
            }
        }
    }
}

