/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot;

import java.util.Comparator;
import org.gradle.internal.file.FileMetadata;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.snapshot.DirectorySnapshot;
import org.gradle.internal.snapshot.FileSystemNode;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.MetadataSnapshot;
import org.gradle.internal.snapshot.MissingFileSnapshot;
import org.gradle.internal.snapshot.PathUtil;
import org.gradle.internal.snapshot.RegularFileSnapshot;

public interface FileSystemLocationSnapshot
extends FileSystemSnapshot,
FileSystemNode,
MetadataSnapshot {
    public static final Comparator<FileSystemLocationSnapshot> BY_NAME = Comparator.comparing(FileSystemLocationSnapshot::getName, PathUtil::compareFileNames);

    public String getName();

    public String getAbsolutePath();

    public HashCode getHash();

    public boolean isContentAndMetadataUpToDate(FileSystemLocationSnapshot var1);

    public boolean isContentUpToDate(FileSystemLocationSnapshot var1);

    public FileMetadata.AccessType getAccessType();

    public void accept(FileSystemLocationSnapshotVisitor var1);

    public <T> T accept(FileSystemLocationSnapshotTransformer<T> var1);

    public static interface FileSystemLocationSnapshotTransformer<T> {
        public T visitDirectory(DirectorySnapshot var1);

        public T visitRegularFile(RegularFileSnapshot var1);

        public T visitMissing(MissingFileSnapshot var1);
    }

    public static interface FileSystemLocationSnapshotVisitor {
        default public void visitDirectory(DirectorySnapshot directorySnapshot) {
        }

        default public void visitRegularFile(RegularFileSnapshot fileSnapshot) {
        }

        default public void visitMissing(MissingFileSnapshot missingSnapshot) {
        }
    }
}

