/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.gradle.api.internal.tasks.compile.ApiCompilerResult;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;

public class CompilationClassBackupService {
    private final Set<String> classesToCompile;
    private final File destinationDir;
    private final File headerOutputDir;
    private final File classBackupDir;
    private final ApiCompilerResult result;
    private final AtomicLong uniqueIndex;
    private final boolean shouldBackupFiles;

    public CompilationClassBackupService(JavaCompileSpec spec, ApiCompilerResult result) {
        this.classesToCompile = spec.getClassesToCompile();
        this.destinationDir = spec.getDestinationDir();
        this.headerOutputDir = spec.getCompileOptions().getHeaderOutputDirectory();
        this.classBackupDir = spec.getClassBackupDir();
        this.shouldBackupFiles = this.classBackupDir != null;
        this.result = result;
        this.uniqueIndex = new AtomicLong();
    }

    public void maybeBackupClassFile(String classFqName) {
        if (this.shouldBackupFiles && !this.classesToCompile.contains(classFqName)) {
            String classFilePath = classFqName.replace(".", "/").concat(".class");
            this.maybeBackupFile(this.destinationDir, classFilePath);
            if (this.headerOutputDir != null) {
                String headerFilePath = classFqName.replaceAll("[.$]", "_").concat(".h");
                this.maybeBackupFile(this.headerOutputDir, headerFilePath);
            }
        }
    }

    private void maybeBackupFile(File destinationDir, String relativePath) {
        File classFile = new File(destinationDir, relativePath);
        if (!this.result.getBackupClassFiles().containsKey(classFile.getAbsolutePath()) && classFile.exists()) {
            File backupFile = new File(this.classBackupDir, classFile.getName() + this.uniqueIndex.incrementAndGet());
            CompilationClassBackupService.copy(classFile.toPath(), backupFile.toPath());
            this.result.getBackupClassFiles().put(classFile.getAbsolutePath(), backupFile.getAbsolutePath());
        }
    }

    private static void copy(Path from, Path to) {
        try {
            Files.copy(from, to, StandardCopyOption.COPY_ATTRIBUTES);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

