/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPFileParser;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class MLSXEntryParser
extends FTPFileParser {
    public static final String cvsId = "@(#)$Id: MLSXEntryParser.java,v 1.1 2007/01/15 23:02:50 bruceb Exp $";
    private static final String SIZE = "Size";
    private static final String MODIFY = "Modify";
    private static final String CREATE = "Create";
    private static final String TYPE = "Type";
    private static final String UNIQUE = "Unique";
    private static final String PERM = "Perm";
    private static final String LANG = "Lang";
    private static final String MEDIA_TYPE = "Media-Type";
    private static final String CHARSET = "CharSet";
    private static final String FILE_TYPE = "file";
    private static final String LISTED_DIR_TYPE = "cdir";
    private static final String PARENT_DIR_TYPE = "pdir";
    private static final String SUB_DIR_TYPE = "dir";
    private SimpleDateFormat tsFormat1 = new SimpleDateFormat("yyyyMMddHHmmss");
    private SimpleDateFormat tsFormat2 = new SimpleDateFormat("yyyyMMddHHmmss.SSS");

    public FTPFile parse(String raw) throws ParseException {
        String[] fields = this.split(raw, ';');
        String path = null;
        FTPFile ftpFile = new FTPFile(raw);
        int i = 0;
        while (i < fields.length) {
            String field = fields[i];
            if (i + 1 == fields.length) {
                path = field.trim();
                ftpFile.setPath(path);
                String name = path;
                int pos = name.lastIndexOf(47);
                if (pos >= 0) {
                    name = name.substring(pos);
                }
                ftpFile.setName(name);
            } else {
                int pos = field.indexOf(61);
                if (pos > 0) {
                    String name = field.substring(0, pos);
                    String value = field.substring(++pos);
                    if (name.equalsIgnoreCase(SIZE)) {
                        ftpFile.setSize(this.parseSize(value));
                    } else if (name.equalsIgnoreCase(MODIFY)) {
                        ftpFile.setLastModified(this.parseDate(value));
                    } else if (name.equalsIgnoreCase(TYPE)) {
                        if (value.equalsIgnoreCase(FILE_TYPE)) {
                            ftpFile.setDir(false);
                        } else {
                            ftpFile.setDir(true);
                        }
                    } else if (name.equalsIgnoreCase(PERM)) {
                        ftpFile.setPermissions(value);
                    } else if (name.equalsIgnoreCase(CREATE)) {
                        ftpFile.setCreated(this.parseDate(value));
                    }
                }
            }
            ++i;
        }
        return ftpFile;
    }

    private long parseSize(String value) throws ParseException {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Failed to parse size: " + value, 0);
        }
    }

    private Date parseDate(String value) throws ParseException {
        try {
            return this.tsFormat1.parse(value);
        }
        catch (ParseException parseException) {
            return this.tsFormat2.parse(value);
        }
    }

    public void setLocale(Locale locale) {
    }

    public MLSXEntryParser() {
        this.tsFormat1.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.tsFormat2.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

