/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.security;

import ca.sqlpower.security.PLGroup;
import ca.sqlpower.security.PLSecurityException;
import ca.sqlpower.sql.DBConnection;
import ca.sqlpower.sql.DatabaseObject;
import ca.sqlpower.sql.SQL;
import ca.sqlpower.util.ByteColonFormat;
import ca.sqlpower.util.UnknownFreqCodeException;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class PLUser
implements DatabaseObject,
Serializable {
    private static final Logger logger = Logger.getLogger(PLUser.class);
    protected boolean _alreadyInDatabase = false;
    protected Set groupNameFilter = null;
    protected String userId = null;
    protected String password;
    protected String userName = null;
    protected String emailAddress = null;
    protected Date lastUpdateDate = null;
    protected String lastUpdateUser = null;
    protected String lastUpdateOsUser = null;
    protected Boolean omniscient = null;
    protected Boolean superuser = null;
    protected boolean loaderUser = false;
    protected boolean summarizerUser = false;
    protected boolean matchmakerUser = false;
    protected boolean dashboardUser = false;

    protected PLUser() {
    }

    public PLUser(String userId) {
        this();
        this.userId = userId;
    }

    @SuppressWarnings(value={"SQL_NONCONSTANT_STRING_PASSED_TO_EXECUTE"}, justification="Input values are quoted to prevent SQL injection,and the sql statements in this do not get called repeatedly, sochanging it to a prepared statement does not add much benefit")
    public void storeNoCommit(Connection con) throws SQLException {
        Statement stmt = con.createStatement();
        StringBuffer sql = new StringBuffer();
        if (this._alreadyInDatabase) {
            sql.append("UPDATE pl_user");
            sql.append(" SET user_name=").append(SQL.quote(this.getUserName()));
            if (this.password != null) {
                sql.append(", password=").append(SQL.quote(PLUser.encryptPassword(this.password)));
            }
            sql.append(", email_address=").append(SQL.quote(this.getEmailAddress()));
            sql.append(", last_update_date=").append(DBConnection.getSystemDate(con));
            sql.append(", last_update_user=").append(SQL.quote(DBConnection.getUser(con).toUpperCase()));
            sql.append(", last_update_os_user=").append(SQL.quote("DASHBOARD_FRONTEND"));
            sql.append(", use_loader_ind='").append(this.loaderUser ? (char)'Y' : 'N').append("'");
            sql.append(", use_matchmaker_ind='").append(this.matchmakerUser ? (char)'Y' : 'N').append("'");
            sql.append(", use_summarizer_ind='").append(this.summarizerUser ? (char)'Y' : 'N').append("'");
            sql.append(", use_dashboard_ind='").append(this.dashboardUser ? (char)'Y' : 'N').append("'");
            sql.append(" WHERE user_id = ").append(SQL.quote(this.getUserId()));
            logger.debug((Object)("store query:" + sql));
            stmt.executeUpdate(sql.toString());
        } else {
            sql.append("INSERT INTO pl_user(");
            sql.append(" user_id,");
            if (this.password != null) {
                sql.append(" password,");
            }
            sql.append(" user_name, email_address,");
            sql.append(" last_update_date, last_update_user, last_update_os_user,");
            sql.append(" use_loader_ind, use_matchmaker_ind, use_summarizer_ind, use_dashboard_ind)");
            sql.append(" VALUES( ");
            sql.append(SQL.quote(this.userId.toUpperCase())).append(",");
            if (this.password != null) {
                sql.append(SQL.quote(PLUser.encryptPassword(this.password))).append(", ");
            }
            sql.append(SQL.quote(this.userName)).append(",");
            sql.append(SQL.quote(this.emailAddress)).append(",");
            sql.append(DBConnection.getSystemDate(con)).append(",");
            sql.append(SQL.quote(DBConnection.getUser(con).toUpperCase())).append(",");
            sql.append(SQL.quote("DASHBOARD_FRONTEND")).append(",");
            sql.append("'").append(this.loaderUser ? (char)'Y' : 'N').append("',");
            sql.append("'").append(this.matchmakerUser ? (char)'Y' : 'N').append("',");
            sql.append("'").append(this.summarizerUser ? (char)'Y' : 'N').append("',");
            sql.append("'").append(this.dashboardUser ? (char)'Y' : 'N').append("')");
            stmt.executeUpdate(sql.toString());
            sql.setLength(0);
            sql.append("INSERT INTO user_object_privs(");
            sql.append("user_id,");
            sql.append("object_type, object_name,");
            sql.append("modify_ind, delete_ind, execute_ind, grant_ind,");
            sql.append("last_update_date, last_update_user, last_update_os_user)");
            sql.append("values(");
            sql.append(SQL.quote(this.userId.toUpperCase())).append(",");
            sql.append("'USER', ").append(SQL.quote(this.userId).toUpperCase()).append(",");
            sql.append("'Y', 'Y', 'Y', 'Y',");
            sql.append(DBConnection.getSystemDate(con)).append(",");
            sql.append(SQL.quote(DBConnection.getUser(con).toUpperCase())).append(",");
            sql.append(SQL.quote("DASHBOARD_FRONTEND")).append(")");
            stmt.executeUpdate(sql.toString());
            this._alreadyInDatabase = true;
        }
        if (stmt != null) {
            stmt.close();
        }
    }

    public void store(Connection con) throws SQLException {
        boolean oldACVal = con.getAutoCommit();
        try {
            con.setAutoCommit(false);
            this.storeNoCommit(con);
            con.commit();
        }
        catch (SQLException e) {
            logger.debug((Object)("PLUser: caught " + e));
            e.printStackTrace();
            con.rollback();
            throw e;
        }
        finally {
            con.setAutoCommit(oldACVal);
        }
    }

    public void removeNoCommit(Connection con) throws SQLException {
        Statement stmt = con.createStatement();
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE FROM pl_user");
        sql.append(" WHERE user_id=").append(SQL.quote(this.getUserId()));
        stmt.executeUpdate(sql.toString());
        this._alreadyInDatabase = false;
    }

    public void remove(Connection con) throws SQLException {
        boolean oldACVal = con.getAutoCommit();
        con.setAutoCommit(false);
        try {
            this.removeNoCommit(con);
        }
        catch (SQLException e) {
            logger.debug((Object)("PLUser.remove: caught " + e));
            e.printStackTrace();
            con.rollback();
            throw e;
        }
        finally {
            con.setAutoCommit(oldACVal);
        }
    }

    public static PLUser findByPrimaryKey(Connection con, String userId, String password) throws SQLException, UnknownFreqCodeException, PLSecurityException {
        if (userId == null) {
            throw new NullPointerException("You must specify a userId");
        }
        List oneUser = PLUser.find(con, userId, password, false);
        return (PLUser)oneUser.get(0);
    }

    public static PLUser findByPrimaryKeyDoNotUse(Connection con, String userId, String password, boolean passwordRequired) throws SQLException, UnknownFreqCodeException, PLSecurityException {
        if (userId == null) {
            throw new NullPointerException("You must specify a userId");
        }
        List oneUser = null;
        oneUser = passwordRequired ? PLUser.find(con, userId, password, false) : PLUser.find(con, userId, password, false, false);
        if (oneUser != null) {
            return (PLUser)oneUser.get(0);
        }
        throw new IllegalStateException("find() user did not return anything!");
    }

    public static List findAll(Connection con) throws SQLException, UnknownFreqCodeException, PLSecurityException {
        return PLUser.find(con, null, null, false);
    }

    public static List findByPrefix(Connection con, String searchPrefix) throws SQLException, UnknownFreqCodeException, PLSecurityException {
        return PLUser.find(con, searchPrefix, null, true);
    }

    protected static List find(Connection con, String userId, String password, boolean searchByPrefix) throws SQLException, UnknownFreqCodeException, PLSecurityException {
        return PLUser.find(con, userId, password, searchByPrefix, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static List find(Connection con, String userId, String password, boolean searchByPrefix, boolean passwordRequired) throws SQLException, UnknownFreqCodeException, PLSecurityException {
        if (!passwordRequired) {
            logger.error((Object)"WARNING: YOU ARE USING THE PL USER IN INSECURE MODE!!!");
        }
        if (userId == null && password != null) {
            throw new IllegalArgumentException("You can't look up a user by password");
        }
        String cryptedPassword = null;
        if (password != null) {
            cryptedPassword = PLUser.encryptPassword(password);
        }
        LinkedList<PLUser> results = new LinkedList<PLUser>();
        Statement stmt = null;
        try {
            ResultSet rs;
            boolean hasRows;
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT");
            sql.append(" user_id, user_name,");
            sql.append(" email_address, default_kpi_frequency,");
            sql.append(" show_red_ind, show_yellow_ind, show_green_ind, show_grey_ind,");
            sql.append(" last_update_date, last_update_user, last_update_os_user,");
            sql.append(" use_loader_ind, use_matchmaker_ind, use_summarizer_ind, use_dashboard_ind");
            sql.append(" FROM pl_user");
            if (userId != null) {
                if (searchByPrefix) {
                    sql.append(" WHERE user_id LIKE ").append(SQL.quote(userId + "%"));
                } else {
                    sql.append(" WHERE user_id = ").append(SQL.quote(userId));
                }
                if (passwordRequired && password != null) {
                    sql.append(" AND (password = ").append(SQL.quote(cryptedPassword));
                    sql.append(" OR password IS NULL)");
                }
            }
            sql.append(" ORDER BY user_id");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Finding user: " + sql.toString()));
            }
            if (!(hasRows = (rs = (stmt = con.createStatement()).executeQuery(sql.toString())).next()) && userId != null) {
                throw new PLSecurityException("permission.login", "security.credentials", null);
            }
            if (!hasRows) {
                List list = Collections.EMPTY_LIST;
                return list;
            }
            do {
                PLUser newBean = new PLUser();
                newBean.userId = rs.getString("user_id");
                newBean.password = password;
                newBean.userName = rs.getString("user_name");
                newBean.emailAddress = rs.getString("email_address");
                newBean.lastUpdateDate = rs.getDate("last_update_date");
                newBean.lastUpdateUser = rs.getString("last_update_user");
                newBean.lastUpdateOsUser = rs.getString("last_update_os_user");
                newBean.loaderUser = SQL.decodeInd(rs.getString("use_loader_ind"));
                newBean.matchmakerUser = SQL.decodeInd(rs.getString("use_matchmaker_ind"));
                newBean.summarizerUser = SQL.decodeInd(rs.getString("use_summarizer_ind"));
                newBean.dashboardUser = SQL.decodeInd(rs.getString("use_dashboard_ind"));
                newBean._alreadyInDatabase = true;
                results.add(newBean);
            } while (rs.next());
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
        if (userId != null && !searchByPrefix && results.size() > 1) {
            throw new IllegalStateException("Got more than one user for userId " + userId);
        }
        return results;
    }

    public List getGroups(Connection con) throws SQLException {
        return PLGroup.findByUser(con, this);
    }

    public List getGroupNames(Connection con) throws SQLException {
        return this.getGroupNamesWithFilter(con, this.groupNameFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getGroupNamesWithFilter(Connection con, Set filter) throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        LinkedList<String> results = new LinkedList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT group_name FROM user_group WHERE user_id=").append(SQL.quote(this.getUserId()));
        if (filter != null) {
            sql.append(" AND group_name IN(").append(SQL.quoteCollection(filter)).append(")");
        }
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery(sql.toString());
            while (rs.next()) {
                results.add(rs.getString(1));
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        return results;
    }

    public void refresh(Connection con) throws SQLException, IllegalStateException {
        List singleUser = PLUser.find(con, this.getUserId(), null, false);
        if (singleUser.size() != 1) {
            throw new IllegalStateException("Couldn't find myself while attempting to refresh");
        }
        PLUser fresh = (PLUser)singleUser.get(0);
        this.userName = fresh.userName;
        this.emailAddress = fresh.emailAddress;
        this.lastUpdateDate = fresh.lastUpdateDate;
        this.lastUpdateUser = fresh.lastUpdateUser;
        this.lastUpdateOsUser = fresh.lastUpdateOsUser;
        this.omniscient = null;
        this.superuser = null;
        this.loaderUser = fresh.loaderUser;
        this.summarizerUser = fresh.summarizerUser;
        this.matchmakerUser = fresh.matchmakerUser;
        this.dashboardUser = fresh.dashboardUser;
    }

    protected static String encryptPassword(String plainPassword) {
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new PLSecurityException("permission.login", "security.invalid", null);
        }
        byte[] hashBytes = md5.digest(plainPassword.getBytes());
        ByteColonFormat bcf = new ByteColonFormat();
        bcf.setUsingColons(false);
        StringBuffer cryptedPassword = new StringBuffer(32);
        bcf.format(hashBytes, cryptedPassword, null);
        return cryptedPassword.toString();
    }

    public Set getGroupNameFilter() {
        return this.groupNameFilter;
    }

    public void setGroupNameFilter(Set namesToInclude) {
        this.groupNameFilter = namesToInclude;
        this.omniscient = null;
        this.superuser = null;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String v) {
        this.password = v;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String v) {
        this.userName = v;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String v) {
        this.emailAddress = v;
    }

    public Date getLastUpdateDate() {
        return this.lastUpdateDate;
    }

    public String getLastUpdateUser() {
        return this.lastUpdateUser;
    }

    public String getLastUpdateOsUser() {
        return this.lastUpdateOsUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOmniscient(Connection con) throws SQLException {
        if (this.groupNameFilter != null && !this.groupNameFilter.contains("PL_SUPERUSER")) {
            return false;
        }
        if (this.omniscient == null) {
            Statement stmt = null;
            ResultSet rs = null;
            try {
                stmt = con.createStatement();
                rs = stmt.executeQuery("SELECT 1 FROM user_group WHERE user_id=" + SQL.quote(this.getUserId()) + " AND group_name=" + SQL.quote("PL_SUPERUSER"));
                this.omniscient = rs.next() ? Boolean.TRUE : Boolean.FALSE;
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        return this.omniscient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSuperuser(Connection con) throws SQLException {
        if (this.groupNameFilter != null && !this.groupNameFilter.contains("PL_ADMIN")) {
            return false;
        }
        if (this.superuser == null) {
            Statement stmt = null;
            ResultSet rs = null;
            try {
                stmt = con.createStatement();
                String sql = "SELECT 1 FROM user_group WHERE user_id=" + SQL.quote(this.getUserId()) + " AND group_name=" + SQL.quote("PL_ADMIN");
                logger.debug((Object)("isSuperuser query " + sql));
                rs = stmt.executeQuery(sql);
                this.superuser = rs.next() ? Boolean.TRUE : Boolean.FALSE;
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        logger.debug((Object)("isSuperuser returns " + this.superuser));
        return this.superuser;
    }

    @Override
    public String getObjectType() {
        return "USER";
    }

    @Override
    public String getObjectName() {
        return this.getUserId();
    }

    public boolean isLoaderUser() {
        return this.loaderUser;
    }

    public void setLoaderUser(boolean argLoaderUser) {
        this.loaderUser = argLoaderUser;
    }

    public boolean isSummarizerUser() {
        return this.summarizerUser;
    }

    public void setSummarizerUser(boolean argSummarizerUser) {
        this.summarizerUser = argSummarizerUser;
    }

    public boolean isMatchmakerUser() {
        return this.matchmakerUser;
    }

    public void setMatchmakerUser(boolean argMatchmakerUser) {
        this.matchmakerUser = argMatchmakerUser;
    }

    public boolean isDashboardUser() {
        return this.dashboardUser;
    }

    public void setDashboardUser(boolean argDashboardUser) {
        this.dashboardUser = argDashboardUser;
    }

    public String toString() {
        StringBuffer meString = new StringBuffer();
        meString.append("[PLUser: ");
        meString.append("userId=").append(this.userId);
        meString.append(", userName=").append(this.userName);
        meString.append(", password=[").append(this.password != null ? "not " : "").append("null]");
        meString.append(", groupNameFilter=").append(this.groupNameFilter);
        meString.append(", omniscient=").append(this.omniscient);
        meString.append(", superuser=").append(this.superuser);
        meString.append(", emailAddress=").append(this.emailAddress);
        meString.append(", loaderUser=").append(this.loaderUser);
        meString.append(", summarizerUser=").append(this.summarizerUser);
        meString.append(", matchmakerUser=").append(this.matchmakerUser);
        meString.append(", dashboardUser=").append(this.dashboardUser);
        meString.append("]");
        return meString.toString();
    }
}

