/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.swing;

import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.swing.PDefaultScrollDirector;
import edu.umd.cs.piccolox.swing.PScrollDirector;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JViewport;
import javax.swing.ViewportLayout;

public class PViewport
extends JViewport {
    PScrollDirector scrollDirector;

    public PViewport() {
        this.setScrollDirector(this.createScrollDirector());
    }

    protected LayoutManager createLayoutManager() {
        return new PViewportLayout();
    }

    protected PScrollDirector createScrollDirector() {
        return new PDefaultScrollDirector();
    }

    public void setScrollDirector(PScrollDirector pScrollDirector) {
        if (this.scrollDirector != null) {
            this.scrollDirector.unInstall();
        }
        this.scrollDirector = pScrollDirector;
        if (pScrollDirector != null) {
            this.scrollDirector.install(this, (PCanvas)this.getView());
        }
    }

    public PScrollDirector getScrollDirector() {
        return this.scrollDirector;
    }

    public void setView(Component component) {
        if (!(component instanceof PCanvas)) {
            throw new UnsupportedOperationException("PViewport only supports ZCanvas");
        }
        super.setView(component);
        if (this.scrollDirector != null) {
            this.scrollDirector.install(this, (PCanvas)component);
        }
    }

    public void setViewPosition(Point point) {
        if (this.getView() == null) {
            return;
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = point.x;
        double d4 = point.y;
        Point point2 = this.getViewPosition();
        if (point2 != null) {
            d = ((Point2D)point2).getX();
            d2 = ((Point2D)point2).getY();
        }
        double d5 = d3;
        double d6 = d4;
        if (d != d5 || d2 != d6) {
            this.scrollUnderway = true;
            this.scrollDirector.setViewPosition(d5, d6);
            this.fireStateChanged();
        }
    }

    public Point getViewPosition() {
        if (this.scrollDirector != null) {
            Dimension dimension = this.getExtentSize();
            return this.scrollDirector.getViewPosition(new PBounds(0.0, 0.0, dimension.getWidth(), dimension.getHeight()));
        }
        return null;
    }

    public Dimension getViewSize() {
        Dimension dimension = this.getExtentSize();
        return this.scrollDirector.getViewSize(new PBounds(0.0, 0.0, dimension.getWidth(), dimension.getHeight()));
    }

    public Dimension getViewSize(Rectangle2D rectangle2D) {
        return this.scrollDirector.getViewSize(rectangle2D);
    }

    public void fireStateChanged() {
        super.fireStateChanged();
    }

    public static class PViewportLayout
    extends ViewportLayout {
        public void layoutContainer(Container container) {
            JViewport jViewport = (JViewport)container;
            Component component = jViewport.getView();
            if (component == null) {
                return;
            }
            Dimension dimension = jViewport.getSize();
            jViewport.setViewSize(dimension);
        }
    }
}

