/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3.page;

import java.util.ArrayList;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssSize
extends org.w3c.css.properties.css.CssSize {
    public static final CssIdent[] allowed_modifier;
    public static final CssIdent[] allowed_page_size;
    public static final CssIdent auto;

    public static final CssIdent getAllowedIdent(CssIdent ident) {
        for (CssIdent id : allowed_modifier) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public static final CssIdent getAllowedSizeIdent(CssIdent ident) {
        for (CssIdent id : allowed_page_size) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public CssSize() {
        this.value = initial;
    }

    public CssSize(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        if (check2 && expression.getCount() > 2) {
            throw new InvalidParamException("unrecognize", ac);
        }
        this.setByUser();
        CssValue val = expression.getValue();
        char op = expression.getOperator();
        ArrayList<CssValue> vals = new ArrayList<CssValue>();
        boolean gotSize = false;
        boolean gotModifier = false;
        while (!expression.end()) {
            val = expression.getValue();
            op = expression.getOperator();
            switch (val.getType()) {
                case 5: {
                    val.getCheckableValue().checkEqualsZero(ac, this);
                }
                case 6: {
                    vals.add(val);
                    val.getCheckableValue().checkPositiveness(ac, this);
                    break;
                }
                case 0: {
                    CssIdent ident = (CssIdent)val;
                    if (auto.equals(ident)) {
                        if (expression.getCount() > 1) {
                            throw new InvalidParamException("unrecognize", ac);
                        }
                        vals.add(auto);
                        break;
                    }
                    CssIdent v = null;
                    if (!gotSize) {
                        v = CssSize.getAllowedIdent(ident);
                        boolean bl = gotSize = v != null;
                    }
                    if (v == null && !gotModifier) {
                        v = CssSize.getAllowedSizeIdent(ident);
                        boolean bl = gotModifier = v != null;
                    }
                    if (v != null) {
                        vals.add(v);
                        break;
                    }
                }
                default: {
                    throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                }
            }
            if (op != ' ') {
                throw new InvalidParamException("operator", Character.toString(op), ac);
            }
            expression.next();
        }
        if (vals.size() > 1) {
            CssValue v1 = (CssValue)vals.get(0);
            CssValue v2 = (CssValue)vals.get(1);
            if (v1.getType() != v2.getType()) {
                throw new InvalidParamException("value", v2, this.getPropertyName(), ac);
            }
            if (v1.getType() == 0 && (v1 == auto || v2 == auto)) {
                throw new InvalidParamException("value", auto, this.getPropertyName(), ac);
            }
        }
        this.value = vals.size() == 1 ? (CssValue)vals.get(0) : new CssValueList(vals);
    }

    public CssSize(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    static {
        auto = CssIdent.getIdent("auto");
        String[] _allowed_values = new String[]{"portrait", "landscape"};
        int i = 0;
        allowed_modifier = new CssIdent[_allowed_values.length];
        for (String s : _allowed_values) {
            CssSize.allowed_modifier[i++] = CssIdent.getIdent(s);
        }
        String[] _page_size_values = new String[]{"a5", "a4", "a3", "b5", "b4", "letter", "legal", "ledger"};
        i = 0;
        allowed_page_size = new CssIdent[_page_size_values.length];
        for (String s : _page_size_values) {
            CssSize.allowed_page_size[i++] = CssIdent.getIdent(s);
        }
    }
}

