/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class Xrb28ProtocolDecoder
extends BaseProtocolDecoder {
    private String pendingCommand;
    private static final Pattern PATTERN = new PatternBuilder().text("*").expression("....,").expression("..,").number("d{15},").number("d{12},").optional().expression("..,").number("[01],").number("(dd)(dd)(dd).d+,").expression("([AV]),").number("(dd)(dd.d+),").expression("([NS]),").number("(d{2,3})(dd.d+),").expression("([EW]),").number("(d+),").number("(d+.d+),").number("(dd)(dd)(dd),").number("(-?d+.?d*),").expression(".,").expression(".#").compile();

    public void setPendingCommand(String pendingCommand) {
        this.pendingCommand = pendingCommand;
    }

    public Xrb28ProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String imei;
        DeviceSession deviceSession;
        String sentence = (String)msg;
        String[] values = sentence.replaceAll("#$", "").split(",");
        int index = 0;
        String header = values[index++];
        String vendor = values[index++];
        if ((deviceSession = this.getDeviceSession(channel, remoteAddress, imei = values[index++])) == null) {
            return null;
        }
        String time = values[index].length() == 12 ? values[index++] : null;
        String type = values[index++];
        if (channel != null) {
            StringBuilder response = new StringBuilder("\u00ff\u00ff");
            response.append(header.replaceAll("R$", "S")).append(',');
            response.append(vendor).append(',');
            response.append(imei).append(',');
            if (time != null) {
                response.append(time).append(',');
            }
            if (type.matches("L0|L1|W0|E1")) {
                response.append(type).append("#\n");
                channel.write((Object)new NetworkMessage(response.toString(), remoteAddress));
            } else if (type.equals("R0") && this.pendingCommand != null) {
                String command = this.pendingCommand.equals("alarmArm") ? "L1" : "L0";
                response.append(command);
                CharSequence[] remaining = Arrays.copyOfRange(values, index, values.length);
                response.append(String.join((CharSequence)",", remaining));
                response.append("#\n");
                channel.write((Object)new NetworkMessage(response.toString(), remoteAddress));
                this.pendingCommand = null;
            }
        }
        if (!type.startsWith("D")) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            this.getLastLocation(position, null);
            switch (type) {
                case "Q0": {
                    position.set("battery", (double)Integer.parseInt(values[index++]) * 0.01);
                    position.set("batteryLevel", Integer.parseInt(values[index++]));
                    position.set("rssi", Integer.parseInt(values[index++]));
                    break;
                }
                case "H0": {
                    position.set("blocked", Integer.parseInt(values[index++]) > 0);
                    position.set("battery", (double)Integer.parseInt(values[index++]) * 0.01);
                    position.set("rssi", Integer.parseInt(values[index++]));
                    position.set("batteryLevel", Integer.parseInt(values[index++]));
                    break;
                }
                case "W0": {
                    switch (Integer.parseInt(values[index++])) {
                        case 1: {
                            position.set("alarm", "movement");
                            break;
                        }
                        case 2: {
                            position.set("alarm", "fallDown");
                            break;
                        }
                        case 3: {
                            position.set("alarm", "lowBattery");
                        }
                    }
                    break;
                }
                case "E0": {
                    position.set("alarm", "fault");
                    position.set("error", Integer.parseInt(values[index++]));
                    break;
                }
                case "S1": {
                    position.set("event", Integer.parseInt(values[index++]));
                    break;
                }
                case "R0": 
                case "L0": 
                case "L1": 
                case "S4": 
                case "S5": 
                case "S6": 
                case "S7": 
                case "V0": 
                case "G0": 
                case "K0": 
                case "I0": 
                case "M0": {
                    CharSequence[] remaining = Arrays.copyOfRange(values, index, values.length);
                    position.set("result", String.join((CharSequence)",", remaining));
                }
            }
            return !position.getAttributes().isEmpty() ? position : null;
        }
        Parser parser = new Parser(PATTERN, sentence);
        if (!parser.matches()) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        DateBuilder dateBuilder = new DateBuilder().setTime(parser.nextInt(), parser.nextInt(), parser.nextInt());
        position.setValid(parser.next().equals("A"));
        position.setLatitude(parser.nextCoordinate());
        position.setLongitude(parser.nextCoordinate());
        position.set("sat", parser.nextInt());
        position.set("hdop", parser.nextDouble());
        dateBuilder.setDateReverse(parser.nextInt(), parser.nextInt(), parser.nextInt());
        position.setTime(dateBuilder.getDate());
        position.setAltitude(parser.nextDouble());
        return position;
    }
}

