/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.formatters;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.AccessController;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Handler;
import org.jboss.logmanager.ExtFormatter;

public final class TextBannerFormatter
extends ExtFormatter.Delegating {
    private final Supplier<String> bannerSupplier;
    private static final Supplier<String> EMPTY = TextBannerFormatter.createStringSupplier("");
    private static final StackWalker STACK_WALKER = AccessController.doPrivileged(() -> StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE));

    public TextBannerFormatter(Supplier<String> bannerSupplier, ExtFormatter delegate) {
        super(delegate);
        this.bannerSupplier = Objects.requireNonNull(bannerSupplier, "bannerSupplier");
    }

    @Override
    public String getHead(Handler h) {
        String dh = Objects.requireNonNullElse(this.delegate.getHead(h), "");
        String banner = Objects.requireNonNullElse(this.bannerSupplier.get(), "");
        return banner + dh;
    }

    public static Supplier<String> getEmptySupplier() {
        return EMPTY;
    }

    public static Supplier<String> createStringSupplier(String string) {
        Objects.requireNonNull(string, "string");
        return () -> string;
    }

    public static Supplier<String> createFileSupplier(Path path, Supplier<String> fallback) {
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(fallback, "fallback");
        return () -> {
            try {
                return Files.readString(path, StandardCharsets.UTF_8);
            }
            catch (IOException ignored) {
                return (String)fallback.get();
            }
        };
    }

    public static Supplier<String> createUrlSupplier(URL url, Supplier<String> fallback) {
        Objects.requireNonNull(url, "url");
        Objects.requireNonNull(fallback, "fallback");
        return () -> {
            try {
                InputStream is = url.openStream();
                return is == null ? (String)fallback.get() : TextBannerFormatter.loadStringFromStream(is);
            }
            catch (IOException ignored) {
                return (String)fallback.get();
            }
        };
    }

    public static Supplier<String> createResourceSupplier(String resource, ClassLoader classLoader, Supplier<String> fallback) {
        Objects.requireNonNull(resource, "resource");
        Objects.requireNonNull(classLoader, "classLoader");
        Objects.requireNonNull(fallback, "fallback");
        return () -> {
            try {
                InputStream is = classLoader.getResourceAsStream(resource);
                return is == null ? (String)fallback.get() : TextBannerFormatter.loadStringFromStream(is);
            }
            catch (IOException ignored) {
                return (String)fallback.get();
            }
        };
    }

    public static Supplier<String> createResourceSupplier(String resource, Supplier<String> fallback) {
        return TextBannerFormatter.createResourceSupplier(resource, TextBannerFormatter.getClassLoader(STACK_WALKER.getCallerClass()), fallback);
    }

    private static ClassLoader getClassLoader(Class<?> clazz) {
        return AccessController.doPrivileged(clazz::getClassLoader);
    }

    private static String loadStringFromStream(InputStream is) throws IOException {
        try (InputStream inputStream = is;){
            String string = new String(is.readAllBytes(), StandardCharsets.UTF_8);
            return string;
        }
    }
}

