/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.configuration;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.jboss.logmanager.configuration.ContextConfiguration;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;

class ObjectBuilder<T> {
    private final ContextConfiguration contextConfiguration;
    private final Class<? extends T> baseClass;
    private final String className;
    private final Map<String, String> constructorProperties;
    private final Map<String, String> properties;
    private final Set<PropertyValue> definedProperties;
    private final Set<String> postConstructMethods;
    private String moduleName;

    private ObjectBuilder(ContextConfiguration contextConfiguration, Class<? extends T> baseClass, String className) {
        this.contextConfiguration = contextConfiguration;
        this.baseClass = baseClass;
        this.className = className;
        this.constructorProperties = new LinkedHashMap<String, String>();
        this.properties = new LinkedHashMap<String, String>();
        this.definedProperties = new LinkedHashSet<PropertyValue>();
        this.postConstructMethods = new LinkedHashSet<String>();
    }

    static <T> ObjectBuilder<T> of(ContextConfiguration contextConfiguration, Class<? extends T> baseClass, String className) {
        return new ObjectBuilder<T>(contextConfiguration, baseClass, className);
    }

    ObjectBuilder<T> addConstructorProperty(String name, String value) {
        this.constructorProperties.put(name, value);
        return this;
    }

    ObjectBuilder<T> addPostConstructMethods(String ... methodNames) {
        if (methodNames != null) {
            Collections.addAll(this.postConstructMethods, methodNames);
        }
        return this;
    }

    ObjectBuilder<T> addProperty(String name, String value) {
        this.properties.put(name, value);
        return this;
    }

    ObjectBuilder<T> addDefinedProperty(String name, Class<?> type, Supplier<?> value) {
        this.definedProperties.add(new PropertyValue(name, type, value));
        return this;
    }

    ObjectBuilder<T> setModuleName(String moduleName) {
        this.moduleName = moduleName;
        return this;
    }

    Supplier<T> build() {
        if (this.className == null) {
            throw new IllegalArgumentException("className is null");
        }
        LinkedHashMap<String, String> constructorProperties = new LinkedHashMap<String, String>(this.constructorProperties);
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>(this.properties);
        LinkedHashSet<String> postConstructMethods = new LinkedHashSet<String>(this.postConstructMethods);
        String moduleName = this.moduleName;
        return () -> {
            Constructor<T> constructor;
            Class<T> actualClass;
            ClassLoader classLoader;
            if (moduleName != null) {
                try {
                    classLoader = ModuleFinder.getClassLoader(moduleName);
                }
                catch (Throwable e) {
                    throw new IllegalArgumentException(String.format("Failed to load module \"%s\"", moduleName), e);
                }
            } else {
                classLoader = this.getClass().getClassLoader();
            }
            try {
                actualClass = Class.forName(this.className, true, classLoader).asSubclass(this.baseClass);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Failed to load class \"%s\"", this.className), e);
            }
            int length = constructorProperties.size();
            Class[] paramTypes = new Class[length];
            Object[] params = new Object[length];
            int i = 0;
            for (Map.Entry entry : constructorProperties.entrySet()) {
                String property = (String)entry.getKey();
                Class<? extends T> clazz = ObjectBuilder.getConstructorPropertyType(actualClass, property);
                if (clazz == null) {
                    throw new IllegalArgumentException(String.format("No property named \"%s\" in \"%s\"", property, this.className));
                }
                paramTypes[i] = clazz;
                params[i] = this.getValue(actualClass, property, clazz, (String)entry.getValue());
                ++i;
            }
            try {
                constructor = actualClass.getConstructor(paramTypes);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Failed to locate constructor in class \"%s\"", this.className), e);
            }
            LinkedHashMap<Method, Object> setters = new LinkedHashMap<Method, Object>();
            for (Map.Entry entry : properties.entrySet()) {
                Method method = ObjectBuilder.getPropertySetter(actualClass, (String)entry.getKey());
                if (method == null) {
                    throw new IllegalArgumentException(String.format("Failed to locate setter for property \"%s\" on type \"%s\"", entry.getKey(), this.className));
                }
                Class<?> type = ObjectBuilder.getPropertyType(method);
                if (type == null) {
                    throw new IllegalArgumentException(String.format("Failed to determine type for setter \"%s\" on type \"%s\"", method.getName(), this.className));
                }
                setters.put(method, this.getValue(actualClass, (String)entry.getKey(), type, (String)entry.getValue()));
            }
            for (PropertyValue propertyValue : this.definedProperties) {
                String methodName = ObjectBuilder.getPropertySetterName(propertyValue.name);
                try {
                    Method method = actualClass.getMethod(methodName, propertyValue.type);
                    setters.put(method, propertyValue.value.get());
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalArgumentException(String.format("Failed to find setter method for property \"%s\" on type \"%s\"", propertyValue.name, this.className), e);
                }
            }
            LinkedHashSet<Method> postConstruct = new LinkedHashSet<Method>();
            for (String methodName : postConstructMethods) {
                try {
                    postConstruct.add(actualClass.getMethod(methodName, new Class[0]));
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalArgumentException(String.format("Failed to find post construct method \"%s\" on type \"%s\"", methodName, this.className), e);
                }
            }
            try {
                T t = constructor.newInstance(params);
                for (Map.Entry entry : setters.entrySet()) {
                    ((Method)entry.getKey()).invoke(t, entry.getValue());
                }
                for (Method method : postConstruct) {
                    method.invoke(t, new Object[0]);
                }
                return t;
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(String.format("Failed to instantiate class \"%s\"", this.className), exception);
            }
        };
    }

    private Object getValue(Class<?> objClass, String propertyName, Class<?> paramType, String value) {
        if (value == null) {
            if (paramType.isPrimitive()) {
                throw new IllegalArgumentException(String.format("Cannot assign null value to primitive property \"%s\" of %s", propertyName, objClass));
            }
            return null;
        }
        String trimmedValue = value.trim();
        if (paramType == String.class) {
            return value;
        }
        if (paramType == Level.class) {
            return this.contextConfiguration.getContext().getLevelForName(trimmedValue);
        }
        if (paramType == Logger.class) {
            return this.contextConfiguration.getContext().getLogger(trimmedValue);
        }
        if (paramType == Boolean.TYPE || paramType == Boolean.class) {
            return Boolean.valueOf(trimmedValue);
        }
        if (paramType == Byte.TYPE || paramType == Byte.class) {
            return Byte.valueOf(trimmedValue);
        }
        if (paramType == Short.TYPE || paramType == Short.class) {
            return Short.valueOf(trimmedValue);
        }
        if (paramType == Integer.TYPE || paramType == Integer.class) {
            return Integer.valueOf(trimmedValue);
        }
        if (paramType == Long.TYPE || paramType == Long.class) {
            return Long.valueOf(trimmedValue);
        }
        if (paramType == Float.TYPE || paramType == Float.class) {
            return Float.valueOf(trimmedValue);
        }
        if (paramType == Double.TYPE || paramType == Double.class) {
            return Double.valueOf(trimmedValue);
        }
        if (paramType == Character.TYPE || paramType == Character.class) {
            return Character.valueOf(trimmedValue.length() > 0 ? trimmedValue.charAt(0) : (char)'\u0000');
        }
        if (paramType == TimeZone.class) {
            return TimeZone.getTimeZone(trimmedValue);
        }
        if (paramType == Charset.class) {
            return Charset.forName(trimmedValue);
        }
        if (paramType.isAssignableFrom(Level.class)) {
            return Level.parse(trimmedValue);
        }
        if (paramType.isEnum()) {
            return Enum.valueOf(paramType.asSubclass(Enum.class), trimmedValue);
        }
        if (this.contextConfiguration.hasObject(trimmedValue)) {
            return this.contextConfiguration.getObject(trimmedValue);
        }
        if (this.definedPropertiesContains(propertyName)) {
            PropertyValue propertyValue = this.findDefinedProperty(propertyName);
            if (propertyValue == null) {
                throw new IllegalArgumentException("Unknown parameter type for property " + propertyName + " on " + objClass);
            }
            return propertyValue.value.get();
        }
        throw new IllegalArgumentException("Unknown parameter type for property " + propertyName + " on " + objClass);
    }

    private boolean definedPropertiesContains(String name) {
        return this.findDefinedProperty(name) != null;
    }

    private PropertyValue findDefinedProperty(String name) {
        for (PropertyValue value : this.definedProperties) {
            if (!name.equals(value.name)) continue;
            return value;
        }
        return null;
    }

    private static Class<?> getPropertyType(Class<?> clazz, String propertyName) {
        return ObjectBuilder.getPropertyType(ObjectBuilder.getPropertySetter(clazz, propertyName));
    }

    private static Class<?> getPropertyType(Method setter) {
        return setter != null ? setter.getParameterTypes()[0] : null;
    }

    private static Class<?> getConstructorPropertyType(Class<?> clazz, String propertyName) {
        Method getter = ObjectBuilder.getPropertyGetter(clazz, propertyName);
        return getter != null ? getter.getReturnType() : ObjectBuilder.getPropertyType(clazz, propertyName);
    }

    private static Method getPropertySetter(Class<?> clazz, String propertyName) {
        String set = ObjectBuilder.getPropertySetterName(propertyName);
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(set) || !Modifier.isPublic(method.getModifiers()) || method.getParameterTypes().length != 1) continue;
            return method;
        }
        return null;
    }

    private static Method getPropertyGetter(Class<?> clazz, String propertyName) {
        String upperPropertyName = Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        Pattern pattern = Pattern.compile("(get|has|is)(" + Pattern.quote(upperPropertyName) + ")");
        for (Method method : clazz.getMethods()) {
            if (!pattern.matcher(method.getName()).matches() || !Modifier.isPublic(method.getModifiers()) || method.getParameterTypes().length != 0) continue;
            return method;
        }
        return null;
    }

    private static String getPropertySetterName(String propertyName) {
        return "set" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
    }

    private static class PropertyValue
    implements Comparable<PropertyValue> {
        final String name;
        final Class<?> type;
        final Supplier<?> value;

        private PropertyValue(String name, Class<?> type, Supplier<?> value) {
            this.name = name;
            this.type = type;
            this.value = value;
        }

        @Override
        public int compareTo(PropertyValue o) {
            return this.name.compareTo(o.name);
        }
    }

    static class ModuleFinder {
        private ModuleFinder() {
        }

        static ClassLoader getClassLoader(String moduleName) throws Exception {
            return Holder.getClassLoader(moduleName);
        }

        private static class Holder {
            private Holder() {
            }

            static ClassLoader getClassLoader(String moduleName) throws Exception {
                ModuleLoader moduleLoader = ModuleLoader.forClass(ModuleFinder.class);
                if (moduleLoader == null) {
                    moduleLoader = Module.getBootModuleLoader();
                }
                return moduleLoader.loadModule(moduleName).getClassLoader();
            }
        }
    }
}

