/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo;

import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.BytecodeCreatorImpl;
import io.quarkus.gizmo.IfThenElse;
import io.quarkus.gizmo.ResultHandle;
import java.util.function.Function;

class IfThenElseImpl
extends BytecodeCreatorImpl
implements IfThenElse {
    private byte state = INIT;
    private BranchResult result;
    private static byte INIT = 0;
    private static byte THEN = 1;
    private static byte ELSEIF = (byte)2;
    private static byte ELSE = (byte)3;

    public IfThenElseImpl(BytecodeCreatorImpl enclosing, ResultHandle value) {
        super(enclosing);
        this.result = enclosing.ifTrue(value);
    }

    @Override
    public BytecodeCreator then() {
        if (this.state != INIT) {
            throw new IllegalStateException("A following [else/else-if] block was already created");
        }
        this.state = THEN;
        return this.result.trueBranch();
    }

    @Override
    public BytecodeCreator elseIf(ResultHandle value) {
        if (this.state == INIT) {
            throw this.initialThenNotCreated();
        }
        if (this.state == ELSE) {
            throw this.elseAlreadyCreated();
        }
        this.state = ELSEIF;
        BytecodeCreator falseBranch = this.result.falseBranch();
        this.result = falseBranch.ifTrue(value);
        return this.result.trueBranch();
    }

    @Override
    public BytecodeCreator elseIf(Function<BytecodeCreator, ResultHandle> test) {
        ResultHandle val = test.apply(this.result.falseBranch());
        return this.elseIf(val);
    }

    @Override
    public BytecodeCreator elseThen() {
        if (this.state == INIT) {
            throw this.initialThenNotCreated();
        }
        if (this.state == ELSE) {
            throw this.elseAlreadyCreated();
        }
        this.state = ELSE;
        return this.result.falseBranch();
    }

    private IllegalStateException initialThenNotCreated() {
        return new IllegalStateException("The initial [then] block was not created");
    }

    private IllegalStateException elseAlreadyCreated() {
        return new IllegalStateException("The [else] block was already created");
    }
}

