/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.social.linkedin;

import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.List;
import org.keycloak.broker.oidc.OIDCIdentityProviderConfig;
import org.keycloak.broker.provider.AbstractIdentityProviderFactory;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.broker.social.SocialIdentityProviderFactory;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.representations.OIDCConfigurationRepresentation;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.social.linkedin.LinkedInOIDCIdentityProvider;

public class LinkedInOIDCIdentityProviderFactory
extends AbstractIdentityProviderFactory<LinkedInOIDCIdentityProvider>
implements SocialIdentityProviderFactory<LinkedInOIDCIdentityProvider> {
    public static final String PROVIDER_ID = "linkedin-openid-connect";
    public static final String WELL_KNOWN_URL = "https://www.linkedin.com/oauth/.well-known/openid-configuration";
    private static OIDCConfigurationRepresentation metadata;

    public String getName() {
        return "LinkedIn";
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public LinkedInOIDCIdentityProvider create(KeycloakSession session, IdentityProviderModel model) {
        OIDCConfigurationRepresentation local = metadata;
        if (local == null) {
            local = LinkedInOIDCIdentityProviderFactory.getWellKnownMetadata(session);
            if (local.getIssuer() == null || local.getTokenEndpoint() == null || local.getAuthorizationEndpoint() == null || local.getJwksUri() == null) {
                throw new RuntimeException("Invalid data in the OIDC LinkedIn well-known address.");
            }
            metadata = local;
        }
        OIDCIdentityProviderConfig config = new OIDCIdentityProviderConfig(model);
        config.setIssuer(local.getIssuer());
        config.setAuthorizationUrl(local.getAuthorizationEndpoint());
        config.setTokenUrl(local.getTokenEndpoint());
        if (local.getUserinfoEndpoint() != null) {
            config.setUserInfoUrl(local.getUserinfoEndpoint());
        }
        config.setUseJwksUrl(true);
        config.setJwksUrl(local.getJwksUri());
        config.setValidateSignature(true);
        config.setDisableNonce(true);
        return new LinkedInOIDCIdentityProvider(session, config);
    }

    public OIDCIdentityProviderConfig createConfig() {
        return new OIDCIdentityProviderConfig();
    }

    private static OIDCConfigurationRepresentation getWellKnownMetadata(KeycloakSession session) {
        OIDCConfigurationRepresentation oIDCConfigurationRepresentation;
        block9: {
            SimpleHttp.Response response = SimpleHttp.doGet((String)WELL_KNOWN_URL, (KeycloakSession)session).header("Accept", "application/json").asResponse();
            try {
                if (Response.Status.fromStatusCode((int)response.getStatus()).getFamily() != Response.Status.Family.SUCCESSFUL) {
                    throw new RuntimeException("Error calling the OIDC LinkedIn well-known address. Http status " + response.getStatus());
                }
                oIDCConfigurationRepresentation = (OIDCConfigurationRepresentation)response.asJson(OIDCConfigurationRepresentation.class);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Error calling the OIDC LinkedIn well-known address.", e);
                }
            }
            response.close();
        }
        return oIDCConfigurationRepresentation;
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return ProviderConfigurationBuilder.create().build();
    }
}

