/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientregistration.oidc;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Time;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.protocol.oidc.mappers.PairwiseSubMapperHelper;
import org.keycloak.protocol.oidc.mappers.SHA256PairwiseSubMapper;
import org.keycloak.protocol.oidc.utils.SubjectType;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.oidc.OIDCClientRepresentation;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.Urls;
import org.keycloak.services.clientregistration.AbstractClientRegistrationProvider;
import org.keycloak.services.clientregistration.ClientRegistrationException;
import org.keycloak.services.clientregistration.oidc.DescriptionConverter;
import org.keycloak.services.clientregistration.oidc.OIDCClientRegistrationContext;
import org.keycloak.urls.UrlType;

public class OIDCClientRegistrationProvider
extends AbstractClientRegistrationProvider {
    private static final Logger logger = Logger.getLogger(OIDCClientRegistrationProvider.class);

    public OIDCClientRegistrationProvider(KeycloakSession session) {
        super(session);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createOIDC(OIDCClientRepresentation clientOIDC) {
        if (clientOIDC.getClientId() != null) {
            throw new ErrorResponseException("invalid_client_metadata", "Client Identifier included", Response.Status.BAD_REQUEST);
        }
        try {
            ClientRepresentation client = DescriptionConverter.toInternal(this.session, clientOIDC);
            List grantTypes = clientOIDC.getGrantTypes();
            if (grantTypes != null && grantTypes.contains("urn:ietf:params:oauth:grant-type:uma-ticket")) {
                client.setAuthorizationServicesEnabled(Boolean.valueOf(true));
            }
            if (grantTypes != null && !grantTypes.contains("refresh_token")) {
                OIDCAdvancedConfigWrapper.fromClientRepresentation(client).setUseRefreshToken(false);
            }
            OIDCClientRegistrationContext oidcContext = new OIDCClientRegistrationContext(this.session, client, this, clientOIDC);
            client = this.create(oidcContext);
            ClientModel clientModel = this.session.getContext().getRealm().getClientByClientId(client.getClientId());
            this.updatePairwiseSubMappers(clientModel, SubjectType.parse(clientOIDC.getSubjectType()), clientOIDC.getSectorIdentifierUri());
            this.updateClientRepWithProtocolMappers(clientModel, client);
            this.validateClient(clientModel, clientOIDC, true);
            URI uri = this.getRegistrationClientUri(clientModel);
            clientOIDC = DescriptionConverter.toExternalResponse(this.session, client, uri);
            clientOIDC.setClientIdIssuedAt(Integer.valueOf(Time.currentTime()));
            return Response.created((URI)uri).entity((Object)clientOIDC).build();
        }
        catch (ClientRegistrationException cre) {
            ServicesLogger.LOGGER.clientRegistrationException(cre.getMessage());
            throw new ErrorResponseException("invalid_client_metadata", "Client metadata invalid", Response.Status.BAD_REQUEST);
        }
    }

    @GET
    @Path(value="{clientId}")
    @Produces(value={"application/json"})
    public Response getOIDC(@PathParam(value="clientId") String clientId) {
        ClientModel client = this.session.getContext().getRealm().getClientByClientId(clientId);
        ClientRepresentation clientRepresentation = this.get(client);
        OIDCClientRepresentation clientOIDC = DescriptionConverter.toExternalResponse(this.session, clientRepresentation, this.getRegistrationClientUri(client));
        return Response.ok((Object)clientOIDC).build();
    }

    @PUT
    @Path(value="{clientId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateOIDC(@PathParam(value="clientId") String clientId, OIDCClientRepresentation clientOIDC) {
        try {
            ClientRepresentation client = DescriptionConverter.toInternal(this.session, clientOIDC);
            if (clientOIDC.getScope() != null) {
                ClientModel oldClient = this.session.getContext().getRealm().getClientById(clientOIDC.getClientId());
                Set defaultClientScopes = oldClient.getClientScopes(true).keySet();
                client.setDefaultClientScopes(new ArrayList(defaultClientScopes));
            }
            OIDCClientRegistrationContext oidcContext = new OIDCClientRegistrationContext(this.session, client, this, clientOIDC);
            client = this.update(clientId, oidcContext);
            ClientModel clientModel = this.session.getContext().getRealm().getClientByClientId(client.getClientId());
            this.updatePairwiseSubMappers(clientModel, SubjectType.parse(clientOIDC.getSubjectType()), clientOIDC.getSectorIdentifierUri());
            this.updateClientRepWithProtocolMappers(clientModel, client);
            client.setSecret(clientModel.getSecret());
            client.getAttributes().put("client.secret.expiration.time", clientModel.getAttribute("client.secret.expiration.time"));
            client.getAttributes().put("client.secret.creation.time", clientModel.getAttribute("client.secret.creation.time"));
            this.validateClient(clientModel, clientOIDC, false);
            URI uri = this.getRegistrationClientUri(clientModel);
            clientOIDC = DescriptionConverter.toExternalResponse(this.session, client, uri);
            return Response.ok((Object)clientOIDC).build();
        }
        catch (ClientRegistrationException cre) {
            ServicesLogger.LOGGER.clientRegistrationException(cre.getMessage());
            throw new ErrorResponseException("invalid_client_metadata", "Client metadata invalid", Response.Status.BAD_REQUEST);
        }
    }

    @DELETE
    @Path(value="{clientId}")
    public void deleteOIDC(@PathParam(value="clientId") String clientId) {
        this.delete(clientId);
    }

    private void updatePairwiseSubMappers(ClientModel clientModel, SubjectType subjectType, String sectorIdentifierUri) {
        if (subjectType == SubjectType.PAIRWISE) {
            AtomicBoolean foundPairwise = new AtomicBoolean(false);
            clientModel.getProtocolMappersStream().filter(mapping -> {
                if (mapping.getProtocolMapper().endsWith("-pairwise-sub-mapper")) {
                    foundPairwise.set(true);
                    return true;
                }
                return false;
            }).collect(Collectors.toList()).forEach(mapping -> {
                PairwiseSubMapperHelper.setSectorIdentifierUri(mapping, sectorIdentifierUri);
                clientModel.updateProtocolMapper(mapping);
            });
            if (!foundPairwise.get()) {
                ProtocolMapperRepresentation newPairwise = SHA256PairwiseSubMapper.createPairwiseMapper(sectorIdentifierUri, null);
                clientModel.addProtocolMapper(RepresentationToModel.toModel((ProtocolMapperRepresentation)newPairwise));
            }
        } else {
            clientModel.getProtocolMappersStream().filter(mapperRep -> mapperRep.getProtocolMapper().endsWith("-pairwise-sub-mapper")).collect(Collectors.toList()).forEach(arg_0 -> ((ClientModel)clientModel).removeProtocolMapper(arg_0));
        }
    }

    private void updateClientRepWithProtocolMappers(ClientModel clientModel, ClientRepresentation rep) {
        List mappings = clientModel.getProtocolMappersStream().map(ModelToRepresentation::toRepresentation).collect(Collectors.toList());
        rep.setProtocolMappers(mappings);
    }

    private URI getRegistrationClientUri(ClientModel client) {
        KeycloakContext context = this.session.getContext();
        RealmModel realm = context.getRealm();
        URI backendUri = context.getUri(UrlType.BACKEND).getBaseUri();
        return Urls.clientRegistration(backendUri, realm.getName(), "openid-connect", client.getClientId());
    }
}

