/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.AutoAddScopeBuildItem;
import io.quarkus.arc.deployment.AutoInjectAnnotationBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.CustomScopeAnnotationsBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.logging.Logger;

public class AutoAddScopeProcessor {
    private static final Logger LOGGER = Logger.getLogger(AutoAddScopeProcessor.class);

    @BuildStep
    void annotationTransformer(List<AutoAddScopeBuildItem> autoScopes, final CustomScopeAnnotationsBuildItem scopes, List<AutoInjectAnnotationBuildItem> autoInjectAnnotations, BuildProducer<AnnotationsTransformerBuildItem> annotationsTransformers, BuildProducer<UnremovableBeanBuildItem> unremovableBeans, final BeanArchiveIndexBuildItem beanArchiveIndex) throws Exception {
        if (autoScopes.isEmpty()) {
            return;
        }
        final List sortedAutoScopes = autoScopes.stream().sorted(Comparator.comparingInt(AutoAddScopeBuildItem::getPriority).reversed()).collect(Collectors.toList());
        final Set containerAnnotationNames = autoInjectAnnotations.stream().flatMap(a -> a.getAnnotationNames().stream()).collect(Collectors.toSet());
        containerAnnotationNames.add(DotNames.POST_CONSTRUCT);
        containerAnnotationNames.add(DotNames.PRE_DESTROY);
        containerAnnotationNames.add(DotNames.INJECT);
        final ConcurrentHashMap unremovables = sortedAutoScopes.stream().anyMatch(AutoAddScopeBuildItem::isUnremovable) ? new ConcurrentHashMap() : null;
        annotationsTransformers.produce((BuildItem)new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.CLASS;
            }

            public int getPriority() {
                return 2000;
            }

            public void transform(AnnotationsTransformer.TransformationContext context) {
                if (scopes.isScopeIn(context.getAnnotations())) {
                    return;
                }
                ClassInfo clazz = context.getTarget().asClass();
                DotName scope = null;
                Boolean requiresContainerServices = null;
                String reason = null;
                for (AutoAddScopeBuildItem autoScope : sortedAutoScopes) {
                    if (autoScope.isContainerServicesRequired()) {
                        if (requiresContainerServices == null) {
                            requiresContainerServices = AutoAddScopeProcessor.this.requiresContainerServices(clazz, containerAnnotationNames, beanArchiveIndex.getIndex());
                        }
                        if (!requiresContainerServices.booleanValue()) continue;
                    }
                    if (!autoScope.test(clazz, context.getAnnotations(), beanArchiveIndex.getIndex())) continue;
                    if (scope != null) {
                        BiConsumer<DotName, String> consumer = autoScope.getScopeAlreadyAdded();
                        if (consumer != null) {
                            consumer.accept(scope, reason);
                            continue;
                        }
                        LOGGER.debugf("Scope %s was already added for reason: %s", (Object)scope, (Object)reason);
                        continue;
                    }
                    scope = autoScope.getDefaultScope();
                    reason = autoScope.getReason();
                    ((Transformation)context.transform().add(scope, new AnnotationValue[0])).done();
                    if (unremovables != null && autoScope.isUnremovable()) {
                        unremovables.put(clazz.name(), autoScope);
                    }
                    LOGGER.debugf("Automatically added scope %s to class %s: %s", (Object)scope, (Object)clazz, (Object)autoScope.getReason());
                }
            }
        }));
        if (unremovables != null) {
            unremovableBeans.produce((BuildItem)new UnremovableBeanBuildItem(new Predicate<BeanInfo>(){

                @Override
                public boolean test(BeanInfo bean) {
                    return bean.isClassBean() && unremovables.containsKey(bean.getBeanClass());
                }
            }));
        }
    }

    private boolean requiresContainerServices(ClassInfo clazz, Set<DotName> containerAnnotationNames, IndexView index) {
        if (this.hasContainerAnnotation(clazz, containerAnnotationNames)) {
            return true;
        }
        if (index != null) {
            DotName superName = clazz.superName();
            while (superName != null && !superName.equals((Object)DotNames.OBJECT)) {
                ClassInfo superClass = index.getClassByName(superName);
                if (superClass != null) {
                    if (this.hasContainerAnnotation(superClass, containerAnnotationNames)) {
                        return true;
                    }
                    superName = superClass.superName();
                    continue;
                }
                superName = null;
            }
        }
        return false;
    }

    private boolean hasContainerAnnotation(ClassInfo clazz, Set<DotName> containerAnnotationNames) {
        if (clazz.annotationsMap().isEmpty() || containerAnnotationNames.isEmpty()) {
            return false;
        }
        return this.containsAny(clazz, containerAnnotationNames);
    }

    private boolean containsAny(ClassInfo clazz, Set<DotName> annotationNames) {
        for (DotName annotation : clazz.annotationsMap().keySet()) {
            if (!annotationNames.contains(annotation)) continue;
            return true;
        }
        return false;
    }
}

