/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.bridge.colibri;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.jicofo.TaskPools;
import org.jitsi.jicofo.bridge.colibri.ParticipantInfo;
import org.jitsi.jicofo.conference.source.ConferenceSourceMap;
import org.jitsi.jicofo.conference.source.EndpointSourceSet;
import org.jitsi.jicofo.conference.source.Source;
import org.jitsi.jicofo.conference.source.SsrcGroup;
import org.jitsi.utils.MediaType;
import org.jitsi.xmpp.extensions.colibri.SourcePacketExtension;
import org.jitsi.xmpp.extensions.colibri2.Colibri2Endpoint;
import org.jitsi.xmpp.extensions.colibri2.ConferenceModifiedIQ;
import org.jitsi.xmpp.extensions.colibri2.MediaSource;
import org.jitsi.xmpp.extensions.colibri2.Sources;
import org.jitsi.xmpp.extensions.colibri2.Transport;
import org.jitsi.xmpp.extensions.jingle.SourceGroupPacketExtension;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.StanzaCollector;
import org.jivesoftware.smack.packet.IQ;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\n\u0010\u0002\u001a\u00020\u0003*\u00020\u0004\u001a\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0001\u001a*\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0014\u0010\r\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0004\u0012\u00020\t0\u000eH\u0000\u001a\u0012\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u0001\u001a\u001c\u0010\u0012\u001a\u00020\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"SSRC_OWNER_JVB", "", "parseSources", "Lorg/jitsi/jicofo/conference/source/ConferenceSourceMap;", "Lorg/jitsi/xmpp/extensions/colibri2/ConferenceModifiedIQ;", "parseTransport", "Lorg/jitsi/xmpp/extensions/colibri2/Transport;", "endpointId", "sendIqAndHandleResponseAsync", "", "Lorg/jivesoftware/smack/AbstractXMPPConnection;", "iq", "Lorg/jivesoftware/smack/packet/IQ;", "block", "Lkotlin/Function1;", "toColibriMediaSources", "Lorg/jitsi/xmpp/extensions/colibri2/Sources;", "Lorg/jitsi/jicofo/conference/source/EndpointSourceSet;", "toEndpoint", "Lorg/jitsi/xmpp/extensions/colibri2/Colibri2Endpoint$Builder;", "Lorg/jitsi/jicofo/bridge/colibri/ParticipantInfo;", "create", "", "expire", "jicofo-selector"})
@SourceDebugExtension(value={"SMAP\nExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Extensions.kt\norg/jitsi/jicofo/bridge/colibri/ExtensionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,140:1\n1#2:141\n1855#3:142\n1855#3,2:143\n1855#3,2:145\n1856#3:147\n1855#3,2:148\n1855#3:150\n288#3,2:151\n1856#3:153\n1855#3,2:154\n*S KotlinDebug\n*F\n+ 1 Extensions.kt\norg/jitsi/jicofo/bridge/colibri/ExtensionsKt\n*L\n47#1:142\n48#1:143,2\n53#1:145,2\n47#1:147\n67#1:148,2\n76#1:150\n79#1:151,2\n76#1:153\n92#1:154,2\n*E\n"})
public final class ExtensionsKt {
    @NotNull
    public static final String SSRC_OWNER_JVB = "jvb";

    @Nullable
    public static final Transport parseTransport(@NotNull ConferenceModifiedIQ $this$parseTransport, @NotNull String endpointId) {
        Object v1;
        block1: {
            Intrinsics.checkNotNullParameter($this$parseTransport, "<this>");
            Intrinsics.checkNotNullParameter(endpointId, "endpointId");
            List<Colibri2Endpoint> list = $this$parseTransport.getEndpoints();
            Intrinsics.checkNotNullExpressionValue(list, "getEndpoints(...)");
            Iterable iterable = list;
            for (Object t : iterable) {
                Colibri2Endpoint it = (Colibri2Endpoint)t;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getId(), endpointId)) continue;
                v1 = t;
                break block1;
            }
            v1 = null;
        }
        Colibri2Endpoint colibri2Endpoint = v1;
        return colibri2Endpoint != null ? colibri2Endpoint.getTransport() : null;
    }

    @NotNull
    public static final ConferenceSourceMap parseSources(@NotNull ConferenceModifiedIQ $this$parseSources) {
        ConferenceSourceMap parsedSources;
        block3: {
            Intrinsics.checkNotNullParameter($this$parseSources, "<this>");
            parsedSources = new ConferenceSourceMap(null, 1, null);
            Object object = $this$parseSources.getSources();
            if (object == null || (object = ((Sources)object).getMediaSources()) == null) break block3;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MediaSource mediaSource2 = (MediaSource)element$iv;
                boolean bl = false;
                List<SourcePacketExtension> list = mediaSource2.getSources();
                Intrinsics.checkNotNullExpressionValue(list, "getSources(...)");
                Iterable $this$forEach$iv2 = list;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    SourcePacketExtension sourcePacketExtension = (SourcePacketExtension)element$iv2;
                    boolean bl2 = false;
                    String msid = "mixedmslabel mixedlabel" + mediaSource2.getType() + "0";
                    long l = sourcePacketExtension.getSSRC();
                    MediaType mediaType = mediaSource2.getType();
                    Intrinsics.checkNotNullExpressionValue((Object)mediaType, "getType(...)");
                    Source source = new Source(l, mediaType, sourcePacketExtension.getName(), msid, null, 16, null);
                    parsedSources.add(SSRC_OWNER_JVB, new EndpointSourceSet(source));
                }
                List<SourceGroupPacketExtension> list2 = mediaSource2.getSsrcGroups();
                Intrinsics.checkNotNullExpressionValue(list2, "getSsrcGroups(...)");
                $this$forEach$iv2 = list2;
                $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    SourceGroupPacketExtension it = (SourceGroupPacketExtension)element$iv2;
                    boolean bl3 = false;
                    Intrinsics.checkNotNull(it);
                    MediaType mediaType = mediaSource2.getType();
                    Intrinsics.checkNotNullExpressionValue((Object)mediaType, "getType(...)");
                    parsedSources.add(SSRC_OWNER_JVB, new EndpointSourceSet(SsrcGroup.Companion.fromPacketExtension(it, mediaType)));
                }
            }
        }
        return parsedSources;
    }

    @NotNull
    public static final Sources toColibriMediaSources(@NotNull EndpointSourceSet $this$toColibriMediaSources, @NotNull String endpointId) {
        Intrinsics.checkNotNullParameter($this$toColibriMediaSources, "<this>");
        Intrinsics.checkNotNullParameter(endpointId, "endpointId");
        Map mediaSources = new LinkedHashMap();
        Iterable $this$forEach$iv = $this$toColibriMediaSources.getSources();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MediaSource.Builder mediaSource2;
            Source source = (Source)element$iv;
            boolean bl = false;
            String string = source.getName();
            if (string == null) {
                string = Source.Companion.nameForIdAndMediaType(endpointId, source.getMediaType(), 0);
            }
            String sourceId = string;
            Intrinsics.checkNotNullExpressionValue(mediaSources.computeIfAbsent(sourceId, arg_0 -> ExtensionsKt.toColibriMediaSources$lambda$5$lambda$4(new Function1<String, MediaSource.Builder>(source, sourceId){
                final /* synthetic */ Source $source;
                final /* synthetic */ String $sourceId;
                {
                    this.$source = $source;
                    this.$sourceId = $sourceId;
                    super(1);
                }

                @NotNull
                public final MediaSource.Builder invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return MediaSource.getBuilder().setType(this.$source.getMediaType()).setId(this.$sourceId);
                }
            }, arg_0)), "computeIfAbsent(...)");
            mediaSource2.addSource(Source.toPacketExtension$default(source, null, false, 1, null));
        }
        $this$forEach$iv = $this$toColibriMediaSources.getSsrcGroups();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MediaSource.Builder mediaSource3;
            Source firstSource;
            Object v1;
            SsrcGroup ssrcGroup;
            block7: {
                ssrcGroup = (SsrcGroup)element$iv;
                boolean bl = false;
                if (ssrcGroup.getSsrcs().isEmpty()) continue;
                Iterable $this$firstOrNull$iv = $this$toColibriMediaSources.getSources();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv) {
                    Source it = (Source)element$iv2;
                    boolean bl2 = false;
                    if (!ssrcGroup.getSsrcs().contains(it.getSsrc())) continue;
                    v1 = element$iv2;
                    break block7;
                }
                v1 = null;
            }
            if ((Source)v1 == null) {
                throw new IllegalStateException("An SsrcGroup in an EndpointSourceSet has an SSRC without a Source");
            }
            String string = firstSource.getName();
            if (string == null) {
                string = Source.Companion.nameForIdAndMediaType(endpointId, ssrcGroup.getMediaType(), 0);
            }
            String sourceId = string;
            Intrinsics.checkNotNullExpressionValue(mediaSources.computeIfAbsent(sourceId, arg_0 -> ExtensionsKt.toColibriMediaSources$lambda$8$lambda$7(new Function1<String, MediaSource.Builder>(ssrcGroup, sourceId){
                final /* synthetic */ SsrcGroup $ssrcGroup;
                final /* synthetic */ String $sourceId;
                {
                    this.$ssrcGroup = $ssrcGroup;
                    this.$sourceId = $sourceId;
                    super(1);
                }

                @NotNull
                public final MediaSource.Builder invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return MediaSource.getBuilder().setType(this.$ssrcGroup.getMediaType()).setId(this.$sourceId);
                }
            }, arg_0)), "computeIfAbsent(...)");
            mediaSource3.addSsrcGroup(ssrcGroup.toPacketExtension());
        }
        Sources.Builder builder = Sources.getBuilder();
        Intrinsics.checkNotNullExpressionValue(builder, "getBuilder(...)");
        Sources.Builder sources = builder;
        Iterable $this$forEach$iv2 = mediaSources.values();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            MediaSource.Builder it = (MediaSource.Builder)element$iv;
            boolean bl = false;
            sources.addMediaSource(it.build());
        }
        Sources sources2 = sources.build();
        Intrinsics.checkNotNullExpressionValue(sources2, "build(...)");
        return sources2;
    }

    @NotNull
    public static final Colibri2Endpoint.Builder toEndpoint(@NotNull ParticipantInfo $this$toEndpoint, boolean create, boolean expire2) {
        Colibri2Endpoint.Builder builder;
        Intrinsics.checkNotNullParameter($this$toEndpoint, "<this>");
        Colibri2Endpoint.Builder builder2 = Colibri2Endpoint.getBuilder();
        Intrinsics.checkNotNullExpressionValue(builder2, "getBuilder(...)");
        Colibri2Endpoint.Builder $this$toEndpoint_u24lambda_u2410 = builder = builder2;
        boolean bl = false;
        $this$toEndpoint_u24lambda_u2410.setId($this$toEndpoint.getId());
        if (create) {
            $this$toEndpoint_u24lambda_u2410.setCreate(true);
            $this$toEndpoint_u24lambda_u2410.setStatsId($this$toEndpoint.getStatsId());
            $this$toEndpoint_u24lambda_u2410.addCapability("source-names");
            if ($this$toEndpoint.getSupportsPrivateAddresses()) {
                $this$toEndpoint_u24lambda_u2410.addCapability("private-address-connectivity");
            }
            if ($this$toEndpoint.getUseSsrcRewriting()) {
                $this$toEndpoint_u24lambda_u2410.addCapability("ssrc-rewriting");
            }
        }
        if (!expire2) {
            $this$toEndpoint_u24lambda_u2410.setSources(ExtensionsKt.toColibriMediaSources($this$toEndpoint.getSources(), $this$toEndpoint.getId()));
        }
        if (expire2) {
            $this$toEndpoint_u24lambda_u2410.setExpire(true);
        }
        return builder;
    }

    public static final void sendIqAndHandleResponseAsync(@NotNull AbstractXMPPConnection $this$sendIqAndHandleResponseAsync, @NotNull IQ iq, @NotNull Function1<? super IQ, Unit> block) {
        Intrinsics.checkNotNullParameter($this$sendIqAndHandleResponseAsync, "<this>");
        Intrinsics.checkNotNullParameter(iq, "iq");
        Intrinsics.checkNotNullParameter(block, "block");
        StanzaCollector stanzaCollector = $this$sendIqAndHandleResponseAsync.createStanzaCollectorAndSend(iq);
        TaskPools.Companion.getIoPool().submit(() -> ExtensionsKt.sendIqAndHandleResponseAsync$lambda$11(block, stanzaCollector));
    }

    private static final MediaSource.Builder toColibriMediaSources$lambda$5$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (MediaSource.Builder)$tmp0.invoke(p0);
    }

    private static final MediaSource.Builder toColibriMediaSources$lambda$8$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (MediaSource.Builder)$tmp0.invoke(p0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void sendIqAndHandleResponseAsync$lambda$11(Function1 $block, StanzaCollector $stanzaCollector) {
        Intrinsics.checkNotNullParameter($block, "$block");
        try {
            $block.invoke($stanzaCollector.nextResult());
        }
        finally {
            $stanzaCollector.cancel();
        }
    }
}

