/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.event;

import java.util.HashMap;
import java.util.Map;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.event.EventManager;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.util.StringUtils;

public class IvyEvent {
    private EventManager source;
    private String name;
    private Map attributes = new HashMap();

    protected IvyEvent(String string) {
        this.source = IvyContext.getContext().getEventManager();
        this.name = string;
    }

    protected void addAttribute(String string, String string2) {
        this.attributes.put(string, string2);
    }

    protected void addMDAttributes(ModuleDescriptor moduleDescriptor) {
        this.addMridAttributes(moduleDescriptor.getResolvedModuleRevisionId());
    }

    protected void addMridAttributes(ModuleRevisionId moduleRevisionId) {
        this.addModuleIdAttributes(moduleRevisionId.getModuleId());
        this.addAttribute("revision", moduleRevisionId.getRevision());
        this.addAttribute("branch", moduleRevisionId.getBranch());
        this.addAttributes(moduleRevisionId.getQualifiedExtraAttributes());
        this.addAttributes(moduleRevisionId.getExtraAttributes());
    }

    protected void addModuleIdAttributes(ModuleId moduleId) {
        this.addAttribute("organisation", moduleId.getOrganisation());
        this.addAttribute("module", moduleId.getName());
    }

    protected void addConfsAttribute(String[] stringArray) {
        this.addAttribute("conf", StringUtils.join(stringArray, ", "));
    }

    protected void addAttributes(Map map) {
        this.attributes.putAll(map);
    }

    public EventManager getSource() {
        return this.source;
    }

    public String getName() {
        return this.name;
    }

    public Map getAttributes() {
        return new HashMap(this.attributes);
    }

    public String toString() {
        return this.getName() + " " + this.getAttributes();
    }

    public boolean equals(Object object) {
        if (!(object instanceof IvyEvent)) {
            return false;
        }
        object = (IvyEvent)object;
        return this.getSource().equals(((IvyEvent)object).getSource()) && this.getName().equals(((IvyEvent)object).getName()) && this.attributes.equals(((IvyEvent)object).attributes);
    }

    public int hashCode() {
        int n = 481 + this.getSource().hashCode();
        n = n * 13 + this.getName().hashCode();
        n = n * 13 + this.attributes.hashCode();
        return n;
    }
}

