/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer.tree;

import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBUtility;
import com.ca.commons.naming.DN;
import com.ca.commons.naming.DXAttribute;
import com.ca.commons.naming.DXEntry;
import com.ca.commons.naming.RDN;
import com.ca.directory.jxplorer.ButtonRegister;
import com.ca.directory.jxplorer.JXplorer;
import com.ca.directory.jxplorer.event.JXplorerEvent;
import com.ca.directory.jxplorer.tree.SmartNode;
import com.ca.directory.jxplorer.tree.SmartTree;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.naming.InvalidNameException;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;

public class SmartPopupTool
extends JPopupMenu
implements ActionListener {
    DN cutDN;
    DN copyDN;
    DN selectDN;
    boolean newEnabled = true;
    JMenuItem cut;
    JMenuItem copy;
    JMenuItem paste;
    JMenuItem pasteAlias;
    JMenuItem delete;
    JMenuItem rename;
    JMenuItem search;
    JMenuItem newEntry;
    JMenuItem refresh;
    JMenuItem copydn;
    JMenuItem bookmark;
    ButtonRegister br = null;
    SmartTree tree;
    private static Logger log = Logger.getLogger(SmartPopupTool.class.getName());

    public SmartPopupTool(SmartTree owningTree) {
        this.tree = owningTree;
        String dirImage = JXplorer.getProperty("dir.images");
        String dirIcons = JXplorer.getProperty("dir.icons");
        this.bookmark = new JMenuItem(CBIntText.get("Add to Bookmarks"), new ImageIcon(dirImage + "plus.gif"));
        this.add(this.bookmark);
        this.search = new JMenuItem(CBIntText.get("Search"), new ImageIcon(dirImage + "find.gif"));
        this.add(this.search);
        this.add(new JPopupMenu.Separator());
        this.newEntry = new JMenuItem(CBIntText.get("New"), new ImageIcon(dirImage + "new.gif"));
        this.add(this.newEntry);
        this.copydn = new JMenuItem(CBIntText.get("Copy DN"), new ImageIcon(dirImage + "copy_dn.gif"));
        this.add(this.copydn);
        this.add(new JPopupMenu.Separator());
        this.cut = new JMenuItem(CBIntText.get("Cut Branch"), new ImageIcon(dirImage + "cut.gif"));
        this.add(this.cut);
        this.copy = new JMenuItem(CBIntText.get("Copy Branch"), new ImageIcon(dirImage + "copy.gif"));
        this.add(this.copy);
        this.paste = new JMenuItem(CBIntText.get("Paste Branch"), new ImageIcon(dirImage + "paste.gif"));
        this.add(this.paste);
        this.pasteAlias = new JMenuItem(CBIntText.get("Paste Alias"), new ImageIcon(dirIcons + "alias.gif"));
        this.add(this.pasteAlias);
        this.add(new JPopupMenu.Separator());
        this.delete = new JMenuItem(CBIntText.get("Delete"), new ImageIcon(dirImage + "delete.gif"));
        this.add(this.delete);
        this.rename = new JMenuItem(CBIntText.get("Rename"), new ImageIcon(dirImage + "rename.gif"));
        this.add(this.rename);
        this.refresh = new JMenuItem(CBIntText.get("Refresh"), new ImageIcon(dirImage + "refresh.gif"));
        this.add(this.refresh);
        this.bookmark.setToolTipText(CBIntText.get("Bookmark an entry"));
        this.bookmark.setAccelerator(KeyStroke.getKeyStroke("B".charAt(0), 2, false));
        this.search.setAccelerator(KeyStroke.getKeyStroke("F".charAt(0), 2, false));
        this.search.setToolTipText(CBIntText.get("Search for an entry in the directory."));
        this.cut.setAccelerator(KeyStroke.getKeyStroke("U".charAt(0), 2, false));
        this.cut.setToolTipText(CBIntText.get("Select a subtree to move."));
        this.copy.setAccelerator(KeyStroke.getKeyStroke("O".charAt(0), 2, false));
        this.copy.setToolTipText(CBIntText.get("Select a subtree to copy."));
        this.paste.setAccelerator(KeyStroke.getKeyStroke("P".charAt(0), 2, false));
        this.paste.setToolTipText(CBIntText.get("Paste a previously selected subtree."));
        this.delete.setAccelerator(KeyStroke.getKeyStroke("D".charAt(0), 2, false));
        this.delete.setToolTipText(CBIntText.get("Delete an entry."));
        this.rename.setAccelerator(KeyStroke.getKeyStroke("M".charAt(0), 2, false));
        this.rename.setToolTipText(CBIntText.get("Rename an entry."));
        this.copydn.setAccelerator(KeyStroke.getKeyStroke("Y".charAt(0), 2, false));
        this.copydn.setToolTipText(CBIntText.get("Copy the distinguished name of an entry to the clipboard"));
        this.newEntry.setAccelerator(KeyStroke.getKeyStroke("N".charAt(0), 2, false));
        this.newEntry.setToolTipText(CBIntText.get("Create a new entry."));
        this.refresh.setAccelerator(KeyStroke.getKeyStroke("R".charAt(0), 2, false));
        this.refresh.setToolTipText(CBIntText.get("Refresh an entry."));
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (!(this.getComponent(i) instanceof JMenuItem)) continue;
            ((JMenuItem)this.getComponent(i)).addActionListener(this);
        }
        this.setVisible(false);
        this.cutDN = null;
        this.copyDN = null;
        this.br = JXplorer.getButtonRegister();
        this.br.registerItem(this.br.PASTE, this.paste);
        this.br.registerItem(this.br.PASTE_ALIAS, this.pasteAlias);
        this.br.registerItem(this.br.COPY, this.copy);
        this.br.registerItem(this.br.COPY_DN, this.copydn);
        this.br.registerItem(this.br.CUT, this.cut);
        this.br.registerItem(this.br.DELETE, this.delete);
        this.br.registerItem(this.br.NEW, this.newEntry);
        this.br.registerItem(this.br.RENAME, this.rename);
        this.br.registerItem(this.br.REFRESH, this.refresh);
        this.br.registerItem(this.br.BOOKMARKS, this.bookmark);
        this.br.registerItem(this.br.SEARCH, this.search);
        this.br.setItemEnabled(this.br.PASTE, false);
        this.br.setItemEnabled(this.br.PASTE_ALIAS, false);
    }

    public void show(Component invoker, int x, int y) {
        SmartTree tree = (SmartTree)invoker;
        SmartNode node = tree.getSelectedNode();
        boolean modifiable = node != null && !node.isStructural() && !tree.getName().equalsIgnoreCase("Schema");
        this.br.setItemEnabled(this.br.RENAME, modifiable);
        super.show(invoker, x, y);
    }

    public TreePath getActivePath() {
        return this.tree.getSelectionPath();
    }

    public SmartNode getActiveNode() {
        TreePath path = this.getActivePath();
        return path == null ? null : (SmartNode)path.getLastPathComponent();
    }

    public DN getActiveDN() {
        return this.tree.getTreeModel().getDNForPath(this.getActivePath());
    }

    public void setModifiable(boolean canModify) {
        if (!canModify) {
            this.br.setItemEnabled(this.br.CUT, false);
            this.br.setItemEnabled(this.br.COPY, false);
            this.br.setItemEnabled(this.br.DELETE, false);
            this.br.setItemEnabled(this.br.RENAME, false);
            this.br.setItemEnabled(this.br.NEW, false);
            this.br.setItemEnabled(this.br.SEARCH, false);
            this.br.setItemEnabled(this.br.BOOKMARKS, false);
            this.br.setItemEnabled(this.br.PASTE, false);
            this.br.setItemEnabled(this.br.PASTE_ALIAS, false);
        } else {
            this.br.setItemEnabled(this.br.CUT, true);
            this.br.setItemEnabled(this.br.COPY, true);
            this.br.setItemEnabled(this.br.DELETE, true);
            this.br.setItemEnabled(this.br.RENAME, true);
            this.br.setItemEnabled(this.br.NEW, true);
            this.br.setItemEnabled(this.br.SEARCH, true);
            this.br.setItemEnabled(this.br.BOOKMARKS, true);
        }
    }

    public void setNewEntryEnabled(boolean enable) {
        this.newEnabled = enable;
        this.br.setItemEnabled(this.br.NEW, this.newEnabled);
    }

    public void actionPerformed(ActionEvent ev) {
        Object event = ev.getSource();
        this.setVisible(false);
        this.repaint();
        if (event == this.cut) {
            this.cut();
        } else if (event == this.copy) {
            this.copy();
        } else if (event == this.paste) {
            this.paste();
        } else if (event == this.pasteAlias) {
            this.pasteAlias();
        } else if (event == this.delete) {
            this.delete();
        } else if (event == this.rename) {
            this.rename();
        } else if (event == this.newEntry) {
            this.newEntry();
        } else if (event == this.refresh) {
            this.refresh();
        } else if (event == this.copydn) {
            this.copyDN();
        } else if (event == this.bookmark) {
            this.tree.openAddBookmarkDialog(this.getActiveDN());
        } else if (event == this.search) {
            this.tree.openSearch(this.getActiveDN());
        } else {
            log.warning("Unknown event in popup menu:\n" + ev.toString());
        }
    }

    public void cut() {
        DN activeDN = this.getActiveDN();
        log.fine("Cut " + activeDN);
        this.cutDN = activeDN;
        this.copyDN = null;
        this.selectDN = null;
        this.br.setItemEnabled(this.br.PASTE, true);
        this.br.setItemEnabled(this.br.PASTE_ALIAS, false);
    }

    public void copy() {
        DN activeDN = this.getActiveDN();
        log.fine("Copy " + activeDN);
        this.copyDN = activeDN;
        this.cutDN = null;
        this.selectDN = null;
        this.br.setItemEnabled(this.br.PASTE, true);
        this.br.setItemEnabled(this.br.PASTE_ALIAS, true);
    }

    protected boolean checkAction(String operationType) {
        String prop = JXplorer.getProperty("option.confirmTreeOperations");
        if ("false".equalsIgnoreCase(prop)) {
            return true;
        }
        return JOptionPane.showConfirmDialog(this, CBIntText.get("The {0} operation will modify the directory - continue?", new String[]{operationType}), CBIntText.get("Confirm Tree Operation"), 2, 2) == 0;
    }

    public void paste() {
        DN activeDN = this.getActiveDN();
        if (activeDN == null || this.cutDN == null && this.copyDN == null) {
            return;
        }
        String from = this.copyDN == null ? this.cutDN.toString() : this.copyDN.toString();
        String to = activeDN.toString();
        log.fine("pasting: \n" + from + "\n" + to);
        if (to.endsWith(from)) {
            CBUtility.error(this, CBIntText.get("Unable to paste an object into itself!"));
            return;
        }
        if (this.copyDN != null) {
            this.copy(this.copyDN, activeDN);
        } else if (this.cutDN != null) {
            this.move(this.cutDN, activeDN);
        }
    }

    public void dragMove(DN moveFrom, DN moveTo) {
        try {
            moveTo.addChildRDN(moveFrom.getLowestRDN().toString());
        }
        catch (InvalidNameException e) {
            CBUtility.error(this.tree, CBIntText.get("Unable to add {0} to {1} due to bad name", new String[]{moveFrom.toString(), moveTo.toString()}), (Exception)e);
            return;
        }
        this.tree.modifyEntry(new DXEntry(moveFrom), new DXEntry(moveTo));
        this.cutDN = null;
        this.br.setItemEnabled(this.br.PASTE, false);
        this.br.setItemEnabled(this.br.PASTE_ALIAS, false);
    }

    public void move(DN moveFrom, DN moveTo) {
        if (!this.checkAction("cut")) {
            return;
        }
        try {
            moveTo.addChildRDN(moveFrom.getLowestRDN().toString());
        }
        catch (InvalidNameException e) {
            CBUtility.error(this.tree, CBIntText.get("Unable to add {0} to {1} due to bad name", new String[]{moveFrom.toString(), moveTo.toString()}), (Exception)e);
            return;
        }
        this.tree.modifyEntry(new DXEntry(moveFrom), new DXEntry(moveTo));
        this.cutDN = null;
        this.br.setItemEnabled(this.br.PASTE, false);
        this.br.setItemEnabled(this.br.PASTE_ALIAS, false);
    }

    public void dragCopy(DN copyFrom, DN copyTo) {
        this.tree.copyTree(copyFrom, copyTo);
    }

    public void copy(DN copyFrom, DN copyTo) {
        if (!this.checkAction("paste")) {
            return;
        }
        this.tree.copyTree(copyFrom, copyTo);
    }

    public void delete() {
        DN activeDN = this.getActiveDN();
        if (activeDN == null || activeDN.isEmpty()) {
            log.warning("An invalid DN was requested to be deleted: " + activeDN);
            JOptionPane.showMessageDialog(this, CBIntText.get("Please select a valid entry to delete."), CBIntText.get("No Entry Selected"), 2);
            return;
        }
        if (!this.checkAction("delete")) {
            return;
        }
        log.fine("deleting " + activeDN);
        this.tree.modifyEntry(new DXEntry(activeDN), null);
        this.br.setItemEnabled(this.br.PASTE_ALIAS, false);
        this.tree.clearEntry();
    }

    public void rename() {
        if (!this.checkAction("rename")) {
            return;
        }
        this.tree.getTree().startEditingAtPath(this.getActivePath());
        this.br.setItemEnabled(this.br.PASTE_ALIAS, false);
    }

    public void newEntry() {
        if (!this.newEnabled) {
            CBUtility.warning(this, CBIntText.get("Browser unable to add new entries using ldap 2 connection"), CBIntText.get("reduced funcitonality in ldap 2"));
        } else {
            this.setVisible(false);
            this.repaint();
            this.tree.makeNewEntry(this.getActiveDN());
        }
    }

    public void pasteAlias() {
        if (!this.checkAction("paste alias")) {
            return;
        }
        DN aliasedObject = this.selectDN;
        if (aliasedObject == null) {
            aliasedObject = this.copyDN;
        }
        if (aliasedObject == null) {
            log.warning("no DN selected for aliasing.");
            this.br.setItemEnabled(this.br.PASTE_ALIAS, false);
            return;
        }
        DN newAlias = new DN(this.getActiveDN());
        RDN newAliasName = aliasedObject.getLowestRDN();
        newAlias.add(newAliasName);
        DXEntry alias = new DXEntry(newAlias);
        DXAttribute oc = new DXAttribute("objectClass", "top");
        oc.add("alias");
        alias.put(oc);
        alias.put(new DXAttribute("aliasedObjectName", aliasedObject.toString()));
        alias.put(new DXAttribute(newAliasName.getAtt(), newAliasName.getRawVal()));
        this.tree.modifyEntry(null, alias);
    }

    public void refresh() {
        this.tree.refresh(this.getActiveDN());
    }

    public void copyDN() {
        this.selectDN = new DN(this.getActiveDN());
        StringSelection ss = new StringSelection(this.selectDN.toString());
        Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
        clip.setContents(ss, ss);
        this.tree.fireJXplorerEvent(new JXplorerEvent(this, JXplorerEvent.EventType.DNSELECTED, this.selectDN.toString()));
        if (!this.tree.getName().equalsIgnoreCase("Schema")) {
            this.br.setItemEnabled(this.br.PASTE_ALIAS, true);
        }
        this.br.setItemEnabled(this.br.PASTE, false);
    }
}

