/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.Payload;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.DataMessage;
import net.i2p.data.i2np.DatabaseSearchReplyMessage;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.DeliveryInstructions;
import net.i2p.data.i2np.GarlicMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.ClientMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelPoolSettings;
import net.i2p.router.message.GarlicMessageReceiver;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.util.Log;
import net.i2p.util.RandomSource;

class InboundMessageDistributor
implements GarlicMessageReceiver.CloveReceiver {
    private final RouterContext _context;
    private final Log _log;
    private final Hash _client;
    private final GarlicMessageReceiver _receiver;
    private final String _clientNickname;
    private final long _msgIDBloomXor;

    public InboundMessageDistributor(RouterContext ctx, Hash client) {
        this._context = ctx;
        this._client = client;
        this._log = ctx.logManager().getLog(InboundMessageDistributor.class);
        this._receiver = new GarlicMessageReceiver(ctx, this, client);
        if (this._client != null) {
            TunnelPoolSettings clienttps = this._context.tunnelManager().getInboundSettings(this._client);
            if (this._log.shouldLog(10)) {
                this._log.debug("Initializing client (nickname: " + clienttps.getDestinationNickname() + " b32: " + this._client.toBase32() + ") InboundMessageDistributor with tunnel pool settings: " + clienttps);
            }
            this._clientNickname = clienttps.getDestinationNickname();
            this._msgIDBloomXor = clienttps.getMsgIdBloomXor();
        } else {
            this._clientNickname = "NULL/Expl";
            this._msgIDBloomXor = RandomSource.getInstance().nextLong(0xFFFFFFFFL);
            if (this._log.shouldLog(10)) {
                this._log.debug("Initializing null or exploratory InboundMessageDistributor");
            }
        }
    }

    public void distribute(I2NPMessage msg, Hash target) {
        this.distribute(msg, target, null);
    }

    public void distribute(I2NPMessage msg, Hash target, TunnelId tunnel) {
        int type;
        block34: {
            block33: {
                if (this._log.shouldLog(10)) {
                    this._log.debug("IBMD for " + this._clientNickname + " (" + (this._client != null ? this._client.toBase32() : "null") + ") to " + target + " / " + tunnel + " : " + msg);
                }
                type = msg.getType();
                if (this._client == null) break block33;
                switch (type) {
                    case 3: {
                        break block34;
                    }
                    case 1: {
                        DatabaseStoreMessage dsm = (DatabaseStoreMessage)msg;
                        if (dsm.getEntry().getType() == 0) {
                            if (this._log.shouldLog(30)) {
                                this._log.warn("Inbound DSM received down a tunnel for " + this._clientNickname + " (" + this._client.toBase32() + "): " + msg);
                            }
                            Hash key = dsm.getKey();
                            if (this._context.routerHash().equals(key)) {
                                return;
                            }
                            RouterInfo ri = (RouterInfo)dsm.getEntry();
                            if (!key.equals(ri.getIdentity().getHash())) {
                                return;
                            }
                            if (!ri.isValid()) {
                                return;
                            }
                            RouterInfo oldri = this._context.netDb().lookupRouterInfoLocally(key);
                            if (oldri != null && oldri.getPublished() < ri.getPublished() && !FloodfillNetworkDatabaseFacade.isFloodfill(ri)) {
                                if (this._log.shouldLog(30)) {
                                    this._log.warn("Updating caps for RI " + key + " from \"" + oldri.getCapabilities() + "\" to \"" + ri.getCapabilities() + '\"');
                                }
                                this._context.peerManager().setCapabilities(key, ri.getCapabilities());
                            }
                            return;
                        }
                        if (dsm.getReplyToken() != 0L) {
                            this._context.statManager().addRateData("tunnel.dropDangerousClientTunnelMessage", 1L, type);
                            this._log.error("Dropping LS DSM w/ reply token down a tunnel for " + this._client.toBase32() + ": " + msg);
                            return;
                        }
                        ((LeaseSet)dsm.getEntry()).setReceivedBy(this._client);
                        break block34;
                    }
                    case 10: 
                    case 11: 
                    case 22: 
                    case 24: 
                    case 26: {
                        break block34;
                    }
                    default: {
                        this._context.statManager().addRateData("tunnel.dropDangerousClientTunnelMessage", 1L, type);
                        this._log.error("Dropped dangerous message down a tunnel for " + this._client.toBase32() + ": " + msg, new Exception("cause"));
                        return;
                    }
                }
            }
            switch (type) {
                case 1: {
                    DatabaseStoreMessage dsm = (DatabaseStoreMessage)msg;
                    if (dsm.getReplyToken() != 0L) {
                        this._context.statManager().addRateData("tunnel.dropDangerousExplTunnelMessage", 1L, type);
                        this._log.error("Dropping DSM w/ reply token down a expl. tunnel: " + msg);
                        return;
                    }
                    if (!dsm.getEntry().isLeaseSet()) break;
                    ((LeaseSet)dsm.getEntry()).setReceivedBy(this._client);
                    break;
                }
                case 3: 
                case 10: 
                case 11: 
                case 22: 
                case 24: 
                case 26: {
                    break;
                }
                default: {
                    this._context.statManager().addRateData("tunnel.dropDangerousExplTunnelMessage", 1L, type);
                    this._log.error("Dropped dangerous message down expl tunnel: " + msg, new Exception("cause"));
                    return;
                }
            }
        }
        if (target == null && tunnel == null) {
            if (type == 11) {
                this._context.inNetMessagePool().handleReplies(msg);
                this._receiver.receive((GarlicMessage)msg);
            } else {
                if (this._log.shouldLog(20)) {
                    this._log.info("distributing inbound tunnel message into our inNetMessagePool (for client " + this._clientNickname + " (" + (this._client != null ? this._client.toBase32() : "null") + ") to target=NULL/tunnel=NULL " + msg);
                }
                this._context.inNetMessagePool().add(msg, null, null, this._msgIDBloomXor);
            }
        } else {
            if (this._context.routerHash().equals(target)) {
                if (type == 11) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Dropping inbound garlic message TARGETED TO OUR ROUTER for client " + this._clientNickname + " (" + (this._client != null ? this._client.toBase32() : "null") + ") to " + target + " / " + tunnel);
                    } else if (this._log.shouldLog(30)) {
                        this._log.warn("Dropping inbound message TARGETED TO OUR ROUTER for client " + this._clientNickname + " (" + (this._client != null ? this._client.toBase32() : "null") + ") to " + target + " / " + tunnel + " : " + msg);
                    }
                }
                return;
            }
            if (type == 11) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Dropping targeted inbound garlic message for client " + this._clientNickname + " (" + (this._client != null ? this._client.toBase32() : "null") + ") to " + target + " / " + tunnel);
                } else if (this._log.shouldLog(30)) {
                    this._log.warn("Dropping targeted inbound message for client " + this._clientNickname + " (" + (this._client != null ? this._client.toBase32() : "null") + " to " + target + " / " + tunnel + " : " + msg);
                }
            }
            return;
        }
    }

    @Override
    public void handleClove(DeliveryInstructions instructions, I2NPMessage data) {
        int type = data.getType();
        switch (instructions.getDeliveryMode()) {
            case 0: {
                if (this._log.shouldLog(10)) {
                    this._log.debug("local delivery instructions for clove: " + data.getClass().getSimpleName());
                }
                if (type == 11) {
                    this._receiver.receive((GarlicMessage)data);
                } else if (type == 1) {
                    DatabaseStoreMessage dsm = (DatabaseStoreMessage)data;
                    dsm.setReplyToken(0L);
                    dsm.setReplyTunnel(null);
                    dsm.setReplyGateway(null);
                    if (dsm.getEntry().isLeaseSet()) {
                        ((LeaseSet)dsm.getEntry()).setReceivedBy(this._client);
                        if (this._log.shouldLog(20)) {
                            this._log.info("Storing garlic LS down tunnel for: " + dsm.getKey() + " sent to: " + this._clientNickname + " (" + (this._client != null ? this._client.toBase32() : ") router"));
                        }
                        this._context.inNetMessagePool().add(dsm, null, null, this._msgIDBloomXor);
                    } else {
                        if (this._client != null) {
                            this._context.statManager().addRateData("tunnel.dropDangerousClientTunnelMessage", 1L, 1L);
                            this._log.error("Dropped dangerous message down a tunnel for " + this._clientNickname + " (" + this._client.toBase32() + ") : " + dsm, new Exception("cause"));
                            return;
                        }
                        if (this._log.shouldLog(20)) {
                            this._log.info("Storing garlic RI down tunnel (" + this._clientNickname + ") for: " + dsm.getKey());
                        }
                        this._context.inNetMessagePool().add(dsm, null, null, this._msgIDBloomXor);
                    }
                } else if (this._client != null && type == 3) {
                    DatabaseSearchReplyMessage orig = (DatabaseSearchReplyMessage)data;
                    this._context.inNetMessagePool().add(orig, null, null, this._msgIDBloomXor);
                } else if (type == 20) {
                    this._context.statManager().addRateData("tunnel.handleLoadClove", 1L);
                    data = null;
                } else if (this._client != null && type != 10 && type != 26) {
                    this._context.statManager().addRateData("tunnel.dropDangerousClientTunnelMessage", 1L, data.getType());
                    this._log.error("Dropped dangerous message received down a tunnel for " + this._clientNickname + " (" + this._client.toBase32() + ") : " + data, new Exception("cause"));
                } else {
                    this._context.inNetMessagePool().add(data, null, null, this._msgIDBloomXor);
                }
                return;
            }
            case 1: {
                Hash to = instructions.getDestination();
                if (type != 20) {
                    if (this._log.shouldLog(40)) {
                        this._log.error("cant send a " + data.getClass().getSimpleName() + " to a destination");
                    }
                } else if (this._client != null && this._client.equals(to)) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("data message came down a tunnel for " + this._client.toBase32());
                    }
                    DataMessage dm = (DataMessage)data;
                    Payload payload = new Payload();
                    payload.setEncryptedData(dm.getData());
                    ClientMessage m = new ClientMessage(this._client, payload);
                    this._context.clientManager().messageReceived(m);
                } else if (this._client != null) {
                    TunnelPoolSettings tgt = this._context.tunnelManager().getInboundSettings(to);
                    if (tgt != null && this._client.equals(tgt.getAliasOf())) {
                        if (this._log.shouldLog(10)) {
                            this._log.debug("data message came down a tunnel for " + this._client.toBase32() + " targeting shared " + to.toBase32());
                        }
                        DataMessage dm = (DataMessage)data;
                        Payload payload = new Payload();
                        payload.setEncryptedData(dm.getData());
                        ClientMessage m = new ClientMessage(to, payload);
                        this._context.clientManager().messageReceived(m);
                    } else if (this._log.shouldLog(40)) {
                        this._log.error("Data message came down a tunnel for " + this._client.toBase32() + " but targetted " + to.toBase32());
                    }
                } else if (this._log.shouldLog(40)) {
                    this._log.error("Data message came down an exploratory tunnel targeting " + to);
                }
                return;
            }
            case 2: 
            case 3: {
                if (this._log.shouldLog(20)) {
                    this._log.info("Recursively handling message from targeted clove (for client:" + this._clientNickname + " " + (this._client != null ? this._client.toBase32() : "null") + ", msg type: " + data.getClass().getSimpleName() + "): " + instructions.getRouter() + ":" + instructions.getTunnelId() + " msg: " + data);
                }
                this.distribute(data, instructions.getRouter(), instructions.getTunnelId());
                return;
            }
        }
        if (this._log.shouldLog(40)) {
            this._log.error("Unknown instruction " + instructions.getDeliveryMode() + ": " + instructions);
        }
    }
}

