/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.sftp;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobEntryType;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.sftp.Messages;
import org.pentaho.di.job.entries.sftp.SFTPClient;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntrySFTP
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private String serverName;
    private String serverPort;
    private String userName;
    private String password;
    private String sftpDirectory;
    private String targetDirectory;
    private String wildcard;
    private boolean remove;
    private boolean isaddresult;
    private boolean createtargetfolder;
    private boolean copyprevious;

    public JobEntrySFTP(String n) {
        super(n, "");
        this.serverName = null;
        this.serverPort = "22";
        this.isaddresult = true;
        this.createtargetfolder = false;
        this.copyprevious = false;
        this.setID(-1L);
        this.setJobEntryType(JobEntryType.SFTP);
    }

    public JobEntrySFTP() {
        this("");
    }

    public JobEntrySFTP(JobEntryBase jeb) {
        super(jeb);
    }

    @Override
    public Object clone() {
        JobEntrySFTP je = (JobEntrySFTP)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(200);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"servername", (String)this.serverName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"serverport", (String)this.serverPort));
        retval.append("      ").append(XMLHandler.addTagValue((String)"username", (String)this.userName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.getPassword())));
        retval.append("      ").append(XMLHandler.addTagValue((String)"sftpdirectory", (String)this.sftpDirectory));
        retval.append("      ").append(XMLHandler.addTagValue((String)"targetdirectory", (String)this.targetDirectory));
        retval.append("      ").append(XMLHandler.addTagValue((String)"wildcard", (String)this.wildcard));
        retval.append("      ").append(XMLHandler.addTagValue((String)"remove", (boolean)this.remove));
        retval.append("      ").append(XMLHandler.addTagValue((String)"isaddresult", (boolean)this.isaddresult));
        retval.append("      ").append(XMLHandler.addTagValue((String)"createtargetfolder", (boolean)this.createtargetfolder));
        retval.append("      ").append(XMLHandler.addTagValue((String)"copyprevious", (boolean)this.copyprevious));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.serverName = XMLHandler.getTagValue((Node)entrynode, (String)"servername");
            this.serverPort = XMLHandler.getTagValue((Node)entrynode, (String)"serverport");
            this.userName = XMLHandler.getTagValue((Node)entrynode, (String)"username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)entrynode, (String)"password"));
            this.sftpDirectory = XMLHandler.getTagValue((Node)entrynode, (String)"sftpdirectory");
            this.targetDirectory = XMLHandler.getTagValue((Node)entrynode, (String)"targetdirectory");
            this.wildcard = XMLHandler.getTagValue((Node)entrynode, (String)"wildcard");
            this.remove = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"remove"));
            String addresult = XMLHandler.getTagValue((Node)entrynode, (String)"isaddresult");
            this.isaddresult = Const.isEmpty((String)addresult) ? true : "Y".equalsIgnoreCase(addresult);
            this.createtargetfolder = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"createtargetfolder"));
            this.copyprevious = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"copyprevious"));
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException("Unable to load job entry of type 'SFTP' from XML node", (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, long id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            super.loadRep(rep, id_jobentry, databases, slaveServers);
            this.serverName = rep.getJobEntryAttributeString(id_jobentry, "servername");
            int intServerPort = (int)rep.getJobEntryAttributeInteger(id_jobentry, "serverport");
            this.serverPort = rep.getJobEntryAttributeString(id_jobentry, "serverport");
            if (intServerPort > 0 && Const.isEmpty((String)this.serverPort)) {
                this.serverPort = Integer.toString(intServerPort);
            }
            this.userName = rep.getJobEntryAttributeString(id_jobentry, "username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)rep.getJobEntryAttributeString(id_jobentry, "password"));
            this.sftpDirectory = rep.getJobEntryAttributeString(id_jobentry, "sftpdirectory");
            this.targetDirectory = rep.getJobEntryAttributeString(id_jobentry, "targetdirectory");
            this.wildcard = rep.getJobEntryAttributeString(id_jobentry, "wildcard");
            this.remove = rep.getJobEntryAttributeBoolean(id_jobentry, "remove");
            String addToResult = rep.getStepAttributeString(id_jobentry, "add_to_result_filenames");
            this.isaddresult = Const.isEmpty((String)addToResult) ? true : rep.getStepAttributeBoolean(id_jobentry, "add_to_result_filenames");
            this.createtargetfolder = rep.getJobEntryAttributeBoolean(id_jobentry, "createtargetfolder");
            this.copyprevious = rep.getJobEntryAttributeBoolean(id_jobentry, "copyprevious");
        }
        catch (KettleException dbe) {
            throw new KettleException("Unable to load job entry of type 'SFTP' from the repository for id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_job) throws KettleException {
        try {
            super.saveRep(rep, id_job);
            rep.saveJobEntryAttribute(id_job, this.getID(), "servername", this.serverName);
            rep.saveJobEntryAttribute(id_job, this.getID(), "serverport", this.serverPort);
            rep.saveJobEntryAttribute(id_job, this.getID(), "username", this.userName);
            rep.saveJobEntryAttribute(id_job, this.getID(), "password", Encr.encryptPasswordIfNotUsingVariables((String)this.password));
            rep.saveJobEntryAttribute(id_job, this.getID(), "sftpdirectory", this.sftpDirectory);
            rep.saveJobEntryAttribute(id_job, this.getID(), "targetdirectory", this.targetDirectory);
            rep.saveJobEntryAttribute(id_job, this.getID(), "wildcard", this.wildcard);
            rep.saveJobEntryAttribute(id_job, this.getID(), "remove", this.remove);
            rep.saveJobEntryAttribute(id_job, this.getID(), "isaddresult", this.isaddresult);
            rep.saveJobEntryAttribute(id_job, this.getID(), "createtargetfolder", this.createtargetfolder);
            rep.saveJobEntryAttribute(id_job, this.getID(), "copyprevious", this.copyprevious);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save job entry of type 'SFTP' to the repository for id_job=" + id_job, (Throwable)dbe);
        }
    }

    public String getScpDirectory() {
        return this.sftpDirectory;
    }

    public void setScpDirectory(String directory) {
        this.sftpDirectory = directory;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getWildcard() {
        return this.wildcard;
    }

    public void setWildcard(String wildcard) {
        this.wildcard = wildcard;
    }

    public void setAddToResult(boolean isaddresultin) {
        this.isaddresult = isaddresultin;
    }

    public boolean isAddToResult() {
        return this.isaddresult;
    }

    public String getTargetDirectory() {
        return this.targetDirectory;
    }

    public void setcreateTargetFolder(boolean createtargetfolder) {
        this.createtargetfolder = createtargetfolder;
    }

    public boolean iscreateTargetFolder() {
        return this.createtargetfolder;
    }

    public boolean isCopyPrevious() {
        return this.copyprevious;
    }

    public void setCopyPrevious(boolean copyprevious) {
        this.copyprevious = copyprevious;
    }

    public void setTargetDirectory(String targetDirectory) {
        this.targetDirectory = targetDirectory;
    }

    public void setRemove(boolean remove) {
        this.remove = remove;
    }

    public boolean getRemove() {
        return this.remove;
    }

    public String getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(String serverPort) {
        this.serverPort = serverPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public Result execute(Result previousResult, int nr, Repository rep, Job parentJob) {
        block66: {
            block62: {
                block59: {
                    block68: {
                        log = LogWriter.getInstance();
                        result = previousResult;
                        rows = result.getRows();
                        resultRow = null;
                        result.setResult(false);
                        filesRetrieved = 0L;
                        if (log.isDetailed()) {
                            log.logDetailed(this.toString(), Messages.getString("JobSFTP.Log.StartJobEntry"), new Object[0]);
                        }
                        list_previous_filenames = new HashSet<String>();
                        if (this.copyprevious) {
                            if (rows.size() == 0) {
                                if (log.isDetailed()) {
                                    log.logDetailed(this.toString(), Messages.getString("JobSFTP.ArgsFromPreviousNothing"), new Object[0]);
                                }
                                result.setResult(true);
                                return result;
                            }
                            try {
                                for (iteration = 0; iteration < rows.size(); ++iteration) {
                                    resultRow = (RowMetaAndData)rows.get(iteration);
                                    file_previous = resultRow.getString(0, null);
                                    if (Const.isEmpty((String)file_previous)) continue;
                                    list_previous_filenames.add(file_previous);
                                    if (!log.isDebug()) continue;
                                    log.logDebug(this.toString(), Messages.getString("JobSFTP.Log.FilenameFromResult", file_previous), new Object[0]);
                                }
                            }
                            catch (Exception e) {
                                log.logError(this.toString(), Messages.getString("JobSFTP.Error.ArgFromPrevious"), new Object[0]);
                                result.setNrErrors(1L);
                                return result;
                            }
                        }
                        sftpclient = null;
                        realServerName = this.environmentSubstitute(this.serverName);
                        realServerPort = this.environmentSubstitute(this.serverPort);
                        realUsername = this.environmentSubstitute(this.userName);
                        realPassword = this.environmentSubstitute(this.password);
                        realSftpDirString = this.environmentSubstitute(this.sftpDirectory);
                        realWildcard = this.environmentSubstitute(this.wildcard);
                        realTargetDirectory = this.environmentSubstitute(this.targetDirectory);
                        TargetFolder = null;
                        if (Const.isEmpty((String)realTargetDirectory)) ** GOTO lbl78
                        TargetFolder = KettleVFS.getFileObject((String)realTargetDirectory);
                        TargetFolderExists = TargetFolder.exists();
                        if (!TargetFolderExists) break block68;
                        if (log.isDetailed()) {
                            log.logDetailed(this.toString(), Messages.getString("JobSFTP.Log.TargetFolderExists", realTargetDirectory), new Object[0]);
                        }
                        ** GOTO lbl78
                    }
                    log.logError(this.toString(), Messages.getString("JobSFTP.Error.TargetFolderNotExists", realTargetDirectory), new Object[0]);
                    if (this.createtargetfolder) break block59;
                    result.setNrErrors(1L);
                    var22_26 = result;
                    var28_28 = null;
                    try {
                        if (sftpclient != null) {
                            sftpclient.disconnect();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        if (TargetFolder != null) {
                            TargetFolder.close();
                            TargetFolder = null;
                        }
                        if (list_previous_filenames != null) {
                            list_previous_filenames = null;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    return var22_26;
                }
                TargetFolder.createFolder();
                if (log.isDetailed()) {
                    log.logDetailed(this.toString(), Messages.getString("JobSFTP.Log.TargetFolderCreated", realTargetDirectory), new Object[0]);
                }
lbl78:
                // 5 sources

                if (TargetFolder != null) {
                    TargetFolder.close();
                    TargetFolder = null;
                }
                sftpclient = new SFTPClient(InetAddress.getByName(realServerName), Const.toInt((String)realServerPort, (int)22), realUsername);
                if (log.isDetailed()) {
                    log.logDetailed(this.toString(), Messages.getString("JobSFTP.Log.OpenedConnection", realServerName, realServerPort, realUsername), new Object[0]);
                }
                sftpclient.login(realPassword);
                if (!Const.isEmpty((String)realSftpDirString)) {
                    try {
                        sftpclient.chdir(realSftpDirString);
                    }
                    catch (Exception e) {
                        log.logError(this.toString(), Messages.getString("JobSFTP.Error.CanNotFindRemoteFolder", realSftpDirString), new Object[0]);
                        throw new Exception(e);
                    }
                    if (log.isDetailed()) {
                        log.logDetailed(this.toString(), Messages.getString("JobSFTP.Log.ChangedDirectory", realSftpDirString), new Object[0]);
                    }
                }
                pattern = null;
                filelist = sftpclient.dir();
                if (filelist != null) break block62;
                result.setResult(true);
                if (log.isDetailed()) {
                    log.logDetailed(this.toString(), Messages.getString("JobSFTP.Log.Found", "0"), new Object[0]);
                }
                var23_38 = result;
                var28_29 = null;
                try {
                    if (sftpclient != null) {
                        sftpclient.disconnect();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (TargetFolder != null) {
                        TargetFolder.close();
                        TargetFolder = null;
                    }
                    if (list_previous_filenames != null) {
                        list_previous_filenames = null;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                return var23_38;
            }
            if (log.isDetailed()) {
                log.logDetailed(this.toString(), Messages.getString("JobSFTP.Log.Found", "" + filelist.length), new Object[0]);
            }
            if (!this.copyprevious && !Const.isEmpty((String)realWildcard)) {
                pattern = Pattern.compile(realWildcard);
            }
            for (i = 0; i < filelist.length && !parentJob.isStopped(); ++i) {
                getIt = true;
                if (this.copyprevious) {
                    getIt = list_previous_filenames.contains(filelist[i]);
                } else if (pattern != null) {
                    matcher = pattern.matcher(filelist[i]);
                    getIt = matcher.matches();
                }
                if (!getIt) continue;
                if (log.isDebug()) {
                    log.logDebug(this.toString(), Messages.getString("JobSFTP.Log.GettingFiles", filelist[i], realTargetDirectory), new Object[0]);
                }
                targetFilename = realTargetDirectory + Const.FILE_SEPARATOR + filelist[i];
                sftpclient.get(targetFilename, filelist[i]);
                ++filesRetrieved;
                if (this.isaddresult) {
                    resultFile = new ResultFile(0, KettleVFS.getFileObject((String)targetFilename), parentJob.getJobname(), this.toString());
                    result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                    if (log.isDetailed()) {
                        log.logDetailed(this.toString(), Messages.getString("JobSFTP.Log.FilenameAddedToResultFilenames", filelist[i]), new Object[0]);
                    }
                }
                if (log.isDetailed()) {
                    log.logDetailed(this.toString(), Messages.getString("JobSFTP.Log.TransferedFile", filelist[i]), new Object[0]);
                }
                if (!this.remove) continue;
                sftpclient.delete(filelist[i]);
                if (!log.isDetailed()) continue;
                log.logDetailed(this.toString(), Messages.getString("JobSFTP.Log.DeletedFile", filelist[i]), new Object[0]);
            }
            result.setResult(true);
            result.setNrFilesRetrieved(filesRetrieved);
            var28_30 = null;
            try {
                if (sftpclient != null) {
                    sftpclient.disconnect();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (TargetFolder != null) {
                    TargetFolder.close();
                    TargetFolder = null;
                }
                if (list_previous_filenames != null) {
                    list_previous_filenames = null;
                }
                break block66;
            }
            catch (Exception e) {}
            break block66;
            {
                catch (Exception e) {
                    result.setNrErrors(1L);
                    log.logError(this.toString(), Messages.getString("JobSFTP.Error.GettingFiles", e.getMessage()), new Object[0]);
                    log.logError(this.toString(), Const.getStackTracker((Throwable)e), new Object[0]);
                    var28_31 = null;
                    try {
                        if (sftpclient != null) {
                            sftpclient.disconnect();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        if (TargetFolder != null) {
                            TargetFolder.close();
                            TargetFolder = null;
                        }
                        if (list_previous_filenames != null) {
                            list_previous_filenames = null;
                        }
                        break block66;
                    }
                    catch (Exception e) {}
                }
            }
            catch (Throwable var27_43) {
                var28_32 = null;
                try {
                    if (sftpclient != null) {
                        sftpclient.disconnect();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (TargetFolder != null) {
                        TargetFolder.close();
                        TargetFolder = null;
                    }
                    if (list_previous_filenames != null) {
                        list_previous_filenames = null;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw var27_43;
            }
        }
        return result;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (!Const.isEmpty((String)this.serverName)) {
            String realServerName = jobMeta.environmentSubstitute(this.serverName);
            ResourceReference reference = new ResourceReference(this);
            reference.getEntries().add(new ResourceEntry(realServerName, ResourceEntry.ResourceType.SERVER));
            references.add(reference);
        }
        return references;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        JobEntryValidatorUtils.andValidator().validate(this, "serverName", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace(ctx, this.getVariables());
        AndValidator.putValidators(ctx, JobEntryValidatorUtils.notBlankValidator(), JobEntryValidatorUtils.fileExistsValidator());
        JobEntryValidatorUtils.andValidator().validate(this, "targetDirectory", remarks, ctx);
        JobEntryValidatorUtils.andValidator().validate(this, "userName", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "password", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notNullValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "serverPort", remarks, AndValidator.putValidators(JobEntryValidatorUtils.integerValidator()));
    }

    public static void main(String[] args) {
        ArrayList<CheckResultInterface> remarks = new ArrayList<CheckResultInterface>();
        new JobEntrySFTP().check(remarks, null);
        System.out.printf("Remarks: %s\n", remarks);
    }
}

