/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import javax.swing.SwingUtilities;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.action.AbstractDrawingViewAction;

public class ZoomAction
extends AbstractDrawingViewAction {
    private double scaleFactor;
    private AbstractButton button;
    private String label;

    public ZoomAction(DrawingEditor drawingEditor, double d, AbstractButton abstractButton) {
        this((DrawingView)null, d, abstractButton);
        this.setEditor(drawingEditor);
    }

    public ZoomAction(DrawingView drawingView, double d, AbstractButton abstractButton) {
        super(drawingView);
        this.scaleFactor = d;
        this.button = abstractButton;
        this.label = (int)(d * 100.0) + " %";
        this.putValue("Default", this.label);
        this.putValue("Name", this.label);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.button != null) {
            this.button.setText(this.label);
        }
        final Rectangle rectangle = this.getView().getComponent().getVisibleRect();
        final double d = this.getView().getScaleFactor();
        this.getView().setScaleFactor(this.scaleFactor);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (rectangle != null) {
                    rectangle.x = (int)((double)rectangle.x / d * ZoomAction.this.scaleFactor);
                    rectangle.y = (int)((double)rectangle.y / d * ZoomAction.this.scaleFactor);
                    rectangle.width = (int)((double)rectangle.width / d * ZoomAction.this.scaleFactor);
                    rectangle.height = (int)((double)rectangle.height / d * ZoomAction.this.scaleFactor);
                    rectangle.x += rectangle.width / 3;
                    rectangle.y += rectangle.height / 3;
                    rectangle.width /= 3;
                    rectangle.height /= 3;
                    ZoomAction.this.getView().getComponent().scrollRectToVisible(rectangle);
                }
            }
        });
    }
}

