%% Generated by lilypond-book
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************

#(ly:set-option 'eps-box-padding 3.000000)



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}




% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "/lilypond-2.24.3/input/regression/alternative-nest-end-end.ly"
\sourcefileline 0
\version "2.23.6"

#(ly:set-option 'warning-as-error #t)

\header {
  texidoc="This case nests one @code{\\alternative} within another at
the tail end of a @code{\\repeat volta}.  Alternative bar numbering is
enabled.

The outer alternative receives a volta bracket and alternative bar
numbering.

The inner alternative receives volta brackets and does not interrupt
the bar numbering of the outer alternative.

The music unfolds to AB ACDE ACDF."
}

\layout {
  \context {
    \Score
    alternativeNumberingStyle = #'numbers-with-letters
    \override BarNumber.break-visibility = #all-visible
  }
}

piece = \new Voice \fixed c' {
  \repeat volta 3 {
    s1_"A"
    \alternative {
      \volta 1 {
        s1_"B"
      }
      \volta 2,3 {
        \set Score.voltaSpannerDuration = #(ly:make-moment 1)
        s1_"C"
        s1_"D"
        \alternative {
          \volta 2 s1_"E"
          \volta 3 s1_"F"
        }
      }
    }
  }
  \fine
}

\new Score { \piece }
\new Score { \unfoldRepeats \piece }



% ****************************************************************
% end ly snippet
% ****************************************************************
