%% Generated by lilypond-book
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************

#(ly:set-option 'eps-box-padding 3.000000)



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}




% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "/lilypond-2.24.3/input/regression/repeat-ds-body-empty.ly"
\sourcefileline 0
\version "2.23.6"

#(ly:set-option 'warning-as-error #t)

\header {
  texidoc="If the body of a segno repeat is empty, the result might be
ugly, but it does not manifestly contradict the input.  The margin
labels show the expected note performance sequence."
}

body = { }

\score {
  \new Staff {
    R1 | \repeat segno 2 \body | R1
  }
}

\score {
  \new Staff \with { instrumentName = "A" } {
    %% This test is not focused on empty alternatives, however an
    %% empty final alternative is the typical way to code "al Coda"
    %% form to avoid getting a coda mark.  The user would normally
    %% define a section label instead, but we want to test without
    %% one.
    R1 | \repeat segno 2 \body \alternative { a'1 <> } | R1
  }
}

\score {
  \new Staff \with { instrumentName = "AB" } {
    R1 | \repeat segno 2 \body \alternative { a'1 b' } | R1
  }
}

\score {
  \new Staff \with { instrumentName = "AAB" } {
    R1 | \repeat segno 3 \body \alternative {
      \volta 1,2 a'1
      \volta 3 b'
    } | R1
  }
}

\score {
  \new Staff \with { instrumentName = "ABB" } {
    R1 | \repeat segno 3 \body \alternative {
      \volta 1 a'1
      \volta 2,3 b'
    } | R1
  }
}

\score {
  \new Staff \with { instrumentName = "AABB" } {
    R1 | \repeat segno 4 \body \alternative {
      \volta 1,2 a'1
      \volta 3,4 b'
    } | R1
  }
}



% ****************************************************************
% end ly snippet
% ****************************************************************
