"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PPLFacet = void 0;

var _ppl_datasource = require("../../adaptors/ppl_datasource");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; } /*
                                                                                                                                                                                                                   * Copyright OpenSearch Contributors
                                                                                                                                                                                                                   * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                   */

class PPLFacet {
  constructor(client) {
    this.client = client;

    _defineProperty(this, "fetch", async (request, format, responseFormat) => {
      const res = {
        success: false,
        data: {}
      };

      try {
        const params = {
          body: {
            query: request.body.query
          }
        };

        if (request.body.format !== 'jdbc') {
          params.format = request.body.format;
        }

        const queryRes = await this.client.asScoped(request).callAsCurrentUser(format, params);
        const pplDataSource = new _ppl_datasource.PPLDataSource(queryRes, request.body.format);
        res.success = true;
        res.data = pplDataSource.getDataSource();
      } catch (err) {
        console.error('PPL query fetch err: ', err);
        res.data = err;
      }

      return res;
    });

    _defineProperty(this, "describeQuery", async request => {
      return this.fetch(request, 'ppl.pplQuery', 'json');
    });

    this.client = client;
  }

}

exports.PPLFacet = PPLFacet;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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