"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.visualizationSavedObject = void 0;

var _shared = require("../../common/constants/shared");

var _observability_saved_object_attributes = require("../../common/types/observability_saved_object_attributes");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const visualizationSavedObject = {
  name: _observability_saved_object_attributes.VISUALIZATION_SAVED_OBJECT,
  hidden: false,
  namespaceType: 'single',
  management: {
    defaultSearchField: 'title',
    importableAndExportable: true,
    icon: 'visQueryPPL',

    getTitle(obj) {
      return obj.attributes.title;
    },

    getInAppUrl(obj) {
      const editPath = `#/explorer/${_observability_saved_object_attributes.VISUALIZATION_SAVED_OBJECT}:${obj.id}`;
      const editUrl = `/app/${_shared.observabilityLogsID}${editPath}`;
      return {
        path: editUrl,
        uiCapabilitiesPath: 'observability.show'
      };
    }

  },
  mappings: {
    dynamic: false,
    properties: {
      title: {
        type: 'text'
      },
      description: {
        type: 'text'
      },
      version: {
        type: 'integer'
      }
    }
  },
  migrations: {}
};
exports.visualizationSavedObject = visualizationSavedObject;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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