"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WINDOW = exports.REQUESTS = exports.MILLIS_MULTIPLIER = exports.INTERVAL = exports.GLOBAL_BASIC_COUNTER = exports.DEFAULT_ROLLING_COUNTER = exports.COMPONENTS = exports.CAPACITY = void 0;

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const WINDOW = 3600;
exports.WINDOW = WINDOW;
const INTERVAL = 60;
exports.INTERVAL = INTERVAL;
const CAPACITY = WINDOW / INTERVAL * 2;
exports.CAPACITY = CAPACITY;
const MILLIS_MULTIPLIER = 1000;
exports.MILLIS_MULTIPLIER = MILLIS_MULTIPLIER;
const COMPONENTS = ['application_analytics', 'operational_panels', 'event_analytics', 'notebooks', 'trace_analytics', 'metrics_analytics', 'integrations'];
exports.COMPONENTS = COMPONENTS;
const REQUESTS = ['create', 'get', 'update', 'delete'];
exports.REQUESTS = REQUESTS;

const GLOBAL_BASIC_COUNTER = (() => {
  const counter = {};
  COMPONENTS.forEach(component => {
    counter[component] = {};
    REQUESTS.forEach(request => {
      counter[component][request] = {
        total: 0
      };
    });
  });
  return counter;
})();

exports.GLOBAL_BASIC_COUNTER = GLOBAL_BASIC_COUNTER;

const DEFAULT_ROLLING_COUNTER = (() => {
  const counter = {};
  COMPONENTS.forEach(component => {
    counter[component] = {};
    REQUESTS.forEach(request => {
      counter[component][request] = {
        count: 0,
        system_error: 0,
        user_error: 0
      };
    });
  });
  return counter;
})();

exports.DEFAULT_ROLLING_COUNTER = DEFAULT_ROLLING_COUNTER;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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