.\"
.\" Copyright (c) 2023 Andrea Biscuola <a@abiscuola.com>
.\"
.\" Permission to use, copy, modify, and distribute this software for any
.\" purpose with or without fee is hereby granted, provided that the above
.\" copyright notice and this permission notice appear in all copies.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
.\" WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
.\" MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
.\" ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
.\" WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
.\" ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
.\" OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\"
.Dd August 18, 2023
.Dt IRCTK-IRC n
.Os
.Sh NAME
.Nm irctk-log
.Nd irctk irc conversations logging facility
.Sh SYNOPSIS
.Cm log close Ar chan
.Pp
.Cm log console Ar text
.Pp
.Cm log open Ar network channel
.Pp
.Cm log write Ar chan nick msg timestamp
.Sh DESCRIPTION
The log namespace implements the functions to open, write and close a channel,
or private conversation, log file.
.Pp
.Cm log open
will open, or create, a new log file for
.Ar channel
in the directory of the specified
.Ar network .
.Pp
.Cm log write
writes a new log entry in the file identified by
.Ar chan .
.Ar nick
is the nickname of the user that sent the message,
.Ar msg
is the message text itself and
.Ar timestamp
is the date and time of the message as seconds from the UNIX epoch.
The message format as written in the log file is as following:
.Bd -literal -offset indent
YYYY-mm-ddTHH:MM:SS <nick>: message
.Ed
.Pp
.Cm log console
writes a generic log message on the application standard error channel.
.Pp
.Cm log close
takes care of closing and releasing any resources that was in use by
.Ar chan .
.Sh RETURN VALUES
.Cm log open
returns the channel descriptor for the opened file.
.Pp
.Cm log write
and
.Cm log close
does not return any value.
.Sh FILES
.Bl -tag -compact -width "${HOME}/irc/logsXXXXXXXX"
.It ${HOME}/irc/logs
IRC logs directory.
.El
.Sh SEE ALSO
.Xr irctk 1 ,
.Xr irctk-exts n ,
.Xr irctk-gui n ,
.Xr irctk-irc n ,
.Xr irctk-irctk n
.Sh AUTHORS
.An Andrea Biscuola Aq Mt a@abiscuola.com
